/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.enums;

import com.timevale.esign.paas.guava.common.collect.Maps;
import com.timevale.esign.paas.seal.sdk.util.StringUtils;
import java.util.Map;

public enum IdNoTypeEnum {
    MAINLAND(19),
    HONGKONG(17),
    MACAO(17),
    TAIWAN(18),
    PASSPORT(13),
    OTHER(23);

    private Integer area;
    static Map<String, IdNoTypeEnum> items;

    private IdNoTypeEnum(Integer area) {
        this.area = area;
    }

    public Integer type() {
        return this.area;
    }

    public static IdNoTypeEnum of(Integer type) {
        for (IdNoTypeEnum idNoTypeEnum : IdNoTypeEnum.values()) {
            if (!idNoTypeEnum.area.equals(type)) continue;
            return idNoTypeEnum;
        }
        return null;
    }

    public static boolean valid(String type) {
        if (StringUtils.isBlank(type)) {
            return true;
        }
        return items.containsKey(type);
    }

    public static IdNoTypeEnum getByName(String type) {
        return items.get(type);
    }

    static {
        items = Maps.newHashMap();
        for (IdNoTypeEnum idNoTypeEnum : IdNoTypeEnum.values()) {
            items.put(idNoTypeEnum.name(), idNoTypeEnum);
        }
    }
}

