/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.enums;

import com.timevale.esign.paas.esign.utils.constant.type.Template;
import com.timevale.esign.paas.guava.common.collect.Maps;
import com.timevale.esign.paas.seal.sdk.util.StringUtils;
import com.timevale.esign.paas.tech.enums.ITemplateType;
import java.util.Map;

public enum OrganizeTemplateType implements ITemplateType
{
    STAR(Template.STAR, "simsun"),
    OVAL(Template.OVAL, "simsun"),
    DEDICATED(Template.DEDICATED, "simsun");

    static Map<String, OrganizeTemplateType> items;
    private Template template;
    private String fontName;

    private OrganizeTemplateType(Template template, String fontName) {
        this.template = template;
        this.fontName = fontName;
    }

    @Override
    public Template template() {
        return this.template;
    }

    public String getFontName() {
        return this.fontName;
    }

    public static boolean valid(String type) {
        if (StringUtils.isBlank(type)) {
            return true;
        }
        return items.containsKey(type);
    }

    public static OrganizeTemplateType getByName(String type) {
        return items.get(type);
    }

    static {
        items = Maps.newHashMap();
        for (OrganizeTemplateType organizeTemplateType : OrganizeTemplateType.values()) {
            items.put(organizeTemplateType.name(), organizeTemplateType);
        }
    }
}

