/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.enums;

import com.timevale.esign.paas.esign.utils.constant.type.Color;
import com.timevale.esign.paas.guava.common.collect.Maps;
import com.timevale.esign.paas.seal.sdk.util.StringUtils;
import java.util.Map;

public enum SealColor {
    RED(Color.RED),
    BLUE(Color.BLUE),
    BLACK(Color.BLACK);

    private Color color;
    static Map<String, SealColor> items;

    private SealColor(Color color) {
        this.color = color;
    }

    public Color color() {
        return this.color;
    }

    public static SealColor from(String desc) {
        SealColor[] sealColorArray;
        for (SealColor sealColor : sealColorArray = SealColor.values()) {
            if (!sealColor.color.getColor().equalsIgnoreCase(desc)) continue;
            return sealColor;
        }
        return RED;
    }

    public static boolean valid(String type) {
        if (StringUtils.isBlank(type)) {
            return true;
        }
        return items.containsKey(type);
    }

    public static SealColor getByName(String type) {
        return items.get(type);
    }

    static {
        items = Maps.newHashMap();
        for (SealColor sealColor : SealColor.values()) {
            items.put(sealColor.name(), sealColor);
        }
    }
}

