/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.enums;

import com.timevale.esign.paas.esign.utils.Base64;
import com.timevale.esign.paas.tech.bean.result.VerifyDigitalSignBean;
import com.timevale.esign.paas.tech.bean.result.VerifyDigitalSignP1Bean;
import com.timevale.esign.paas.tech.bean.result.VerifyDigitalSignP7Bean;
import com.timevale.esign.paas.tech.constant.VerificationAlgorithm;
import com.timevale.esign.paas.tech.util.ISignatureVerify;
import com.timevale.esign.paas.tech.util.RSASignatureProperties;
import com.timevale.esign.paas.tech.util.SM2SignatureProperties;
import com.timevale.esign.paas.tech.util.SignatureTemplate;
import java.nio.charset.Charset;
import org.apache.commons.lang.StringUtils;

public enum SignatureVerifyEnum implements ISignatureVerify
{
    SHA256WITHRSA_P1(VerificationAlgorithm.SHA256WITHRSA.getSignAlg(), false){

        @Override
        public boolean verify(VerifyDigitalSignBean verifyDigitalSignBean) throws Exception {
            if (verifyDigitalSignBean instanceof VerifyDigitalSignP1Bean) {
                VerifyDigitalSignP1Bean verifyDigitalSignP1Bean = (VerifyDigitalSignP1Bean)verifyDigitalSignBean;
                RSASignatureProperties rSASignatureProperties = new RSASignatureProperties(new byte[0], Base64.decode(verifyDigitalSignP1Bean.getCert()));
                return SignatureTemplate.verifyWithP1(verifyDigitalSignP1Bean.getPlainText().getBytes("utf-8"), Base64.decode(verifyDigitalSignP1Bean.getSignature()), Base64.decode(verifyDigitalSignP1Bean.getTimestampSignature()), rSASignatureProperties);
            }
            return false;
        }
    }
    ,
    SM3WITHSM2_P1(VerificationAlgorithm.SM3WITHSM2.getSignAlg(), false){

        @Override
        public boolean verify(VerifyDigitalSignBean verifyDigitalSignBean) throws Exception {
            if (verifyDigitalSignBean instanceof VerifyDigitalSignP1Bean) {
                VerifyDigitalSignP1Bean verifyDigitalSignP1Bean = (VerifyDigitalSignP1Bean)verifyDigitalSignBean;
                SM2SignatureProperties sM2SignatureProperties = new SM2SignatureProperties(new byte[0], Base64.decode(verifyDigitalSignP1Bean.getCert()));
                return SignatureTemplate.verifyWithP1(verifyDigitalSignP1Bean.getPlainText().getBytes("utf-8"), Base64.decode(verifyDigitalSignP1Bean.getSignature()), Base64.decode(verifyDigitalSignP1Bean.getTimestampSignature()), sM2SignatureProperties);
            }
            return false;
        }
    }
    ,
    SHA256WITHRSA_P7(VerificationAlgorithm.SHA256WITHRSA.getSignAlg(), true){

        @Override
        public boolean verify(VerifyDigitalSignBean verifyDigitalSignBean) throws Exception {
            VerifyDigitalSignP7Bean verifyDigitalSignP7Bean = (VerifyDigitalSignP7Bean)verifyDigitalSignBean;
            return SignatureTemplate.verifyWithP7(StringUtils.isEmpty((String)verifyDigitalSignP7Bean.getPlainText()) ? new byte[]{} : verifyDigitalSignP7Bean.getPlainText().getBytes(Charset.forName("utf-8")), Base64.decode(verifyDigitalSignP7Bean.getSignature()));
        }
    }
    ,
    SM3WITHSM2_P7(VerificationAlgorithm.SM3WITHSM2.getSignAlg(), true){

        @Override
        public boolean verify(VerifyDigitalSignBean verifyDigitalSignBean) throws Exception {
            VerifyDigitalSignP7Bean verifyDigitalSignP7Bean = (VerifyDigitalSignP7Bean)verifyDigitalSignBean;
            return SignatureTemplate.verifyWithP7(StringUtils.isEmpty((String)verifyDigitalSignP7Bean.getPlainText()) ? new byte[]{} : verifyDigitalSignP7Bean.getPlainText().getBytes(Charset.forName("utf-8")), Base64.decode(verifyDigitalSignP7Bean.getSignature()));
        }
    };

    private String alg;
    private boolean p7;

    private SignatureVerifyEnum(String alg, boolean p7) {
        this.alg = alg;
        this.p7 = p7;
    }

    public static SignatureVerifyEnum getVerifyEnumByAlgAndPkcs(String alg, boolean p7) {
        for (SignatureVerifyEnum signatureVerifyEnum : SignatureVerifyEnum.values()) {
            if (!signatureVerifyEnum.getAlg().equalsIgnoreCase(alg) || signatureVerifyEnum.isP7() != p7) continue;
            return signatureVerifyEnum;
        }
        return null;
    }

    public String getAlg() {
        return this.alg;
    }

    public boolean isP7() {
        return this.p7;
    }
}

