/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tgtext.bouncycastle.asn1.cmc;

import com.timevale.esign.paas.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.cmc.BodyPartID;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.cmc.Utils;

public class BodyPartPath
extends ASN1Object {
    private final BodyPartID[] bodyPartIDs;

    public static BodyPartPath getInstance(Object object) {
        if (object instanceof BodyPartPath) {
            return (BodyPartPath)object;
        }
        if (object != null) {
            return new BodyPartPath(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static BodyPartPath getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return BodyPartPath.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public BodyPartPath(BodyPartID bodyPartID) {
        this.bodyPartIDs = new BodyPartID[]{bodyPartID};
    }

    public BodyPartPath(BodyPartID[] bodyPartIDArray) {
        this.bodyPartIDs = Utils.clone(bodyPartIDArray);
    }

    private BodyPartPath(ASN1Sequence aSN1Sequence) {
        this.bodyPartIDs = Utils.toBodyPartIDArray(aSN1Sequence);
    }

    public BodyPartID[] getBodyPartIDs() {
        return Utils.clone(this.bodyPartIDs);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(this.bodyPartIDs);
    }
}

