/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tgtext.bouncycastle.crypto.engines;

import com.timevale.esign.paas.tgtext.bouncycastle.crypto.engines.Salsa20Engine;
import com.timevale.esign.paas.tgtext.bouncycastle.util.Pack;

public class ChaChaEngine
extends Salsa20Engine {
    public ChaChaEngine() {
    }

    public ChaChaEngine(int n2) {
        super(n2);
    }

    @Override
    public String getAlgorithmName() {
        return "ChaCha" + this.rounds;
    }

    @Override
    protected void advanceCounter(long l2) {
        int n2 = (int)(l2 >>> 32);
        int n3 = (int)l2;
        if (n2 > 0) {
            this.engineState[13] = this.engineState[13] + n2;
        }
        int n4 = this.engineState[12];
        this.engineState[12] = this.engineState[12] + n3;
        if (n4 != 0 && this.engineState[12] < n4) {
            this.engineState[13] = this.engineState[13] + 1;
        }
    }

    @Override
    protected void advanceCounter() {
        this.engineState[12] = this.engineState[12] + 1;
        if (this.engineState[12] == 0) {
            this.engineState[13] = this.engineState[13] + 1;
        }
    }

    @Override
    protected void retreatCounter(long l2) {
        int n2 = (int)(l2 >>> 32);
        int n3 = (int)l2;
        if (n2 != 0) {
            if (((long)this.engineState[13] & 0xFFFFFFFFL) >= ((long)n2 & 0xFFFFFFFFL)) {
                this.engineState[13] = this.engineState[13] - n2;
            } else {
                throw new IllegalStateException("attempt to reduce counter past zero.");
            }
        }
        if (((long)this.engineState[12] & 0xFFFFFFFFL) >= ((long)n3 & 0xFFFFFFFFL)) {
            this.engineState[12] = this.engineState[12] - n3;
        } else if (this.engineState[13] != 0) {
            this.engineState[13] = this.engineState[13] - 1;
            this.engineState[12] = this.engineState[12] - n3;
        } else {
            throw new IllegalStateException("attempt to reduce counter past zero.");
        }
    }

    @Override
    protected void retreatCounter() {
        if (this.engineState[12] == 0 && this.engineState[13] == 0) {
            throw new IllegalStateException("attempt to reduce counter past zero.");
        }
        this.engineState[12] = this.engineState[12] - 1;
        if (this.engineState[12] == -1) {
            this.engineState[13] = this.engineState[13] - 1;
        }
    }

    @Override
    protected long getCounter() {
        return (long)this.engineState[13] << 32 | (long)this.engineState[12] & 0xFFFFFFFFL;
    }

    @Override
    protected void resetCounter() {
        this.engineState[13] = 0;
        this.engineState[12] = 0;
    }

    @Override
    protected void setKey(byte[] byArray, byte[] byArray2) {
        if (byArray != null) {
            if (byArray.length != 16 && byArray.length != 32) {
                throw new IllegalArgumentException(this.getAlgorithmName() + " requires 128 bit or 256 bit key");
            }
            this.packTauOrSigma(byArray.length, this.engineState, 0);
            Pack.littleEndianToInt(byArray, 0, this.engineState, 4, 4);
            Pack.littleEndianToInt(byArray, byArray.length - 16, this.engineState, 8, 4);
        }
        Pack.littleEndianToInt(byArray2, 0, this.engineState, 14, 2);
    }

    @Override
    protected void generateKeyStream(byte[] byArray) {
        ChaChaEngine.chachaCore(this.rounds, this.engineState, this.x);
        Pack.intToLittleEndian(this.x, byArray, 0);
    }

    public static void chachaCore(int n2, int[] nArray, int[] nArray2) {
        if (nArray.length != 16) {
            throw new IllegalArgumentException();
        }
        if (nArray2.length != 16) {
            throw new IllegalArgumentException();
        }
        if (n2 % 2 != 0) {
            throw new IllegalArgumentException("Number of rounds must be even");
        }
        int n3 = nArray[0];
        int n4 = nArray[1];
        int n5 = nArray[2];
        int n6 = nArray[3];
        int n7 = nArray[4];
        int n8 = nArray[5];
        int n9 = nArray[6];
        int n10 = nArray[7];
        int n11 = nArray[8];
        int n12 = nArray[9];
        int n13 = nArray[10];
        int n14 = nArray[11];
        int n15 = nArray[12];
        int n16 = nArray[13];
        int n17 = nArray[14];
        int n18 = nArray[15];
        for (int i2 = n2; i2 > 0; i2 -= 2) {
            n15 = ChaChaEngine.rotl(n15 ^ (n3 += n7), 16);
            n7 = ChaChaEngine.rotl(n7 ^ (n11 += n15), 12);
            n15 = ChaChaEngine.rotl(n15 ^ (n3 += n7), 8);
            n7 = ChaChaEngine.rotl(n7 ^ (n11 += n15), 7);
            n16 = ChaChaEngine.rotl(n16 ^ (n4 += n8), 16);
            n8 = ChaChaEngine.rotl(n8 ^ (n12 += n16), 12);
            n16 = ChaChaEngine.rotl(n16 ^ (n4 += n8), 8);
            n8 = ChaChaEngine.rotl(n8 ^ (n12 += n16), 7);
            n17 = ChaChaEngine.rotl(n17 ^ (n5 += n9), 16);
            n9 = ChaChaEngine.rotl(n9 ^ (n13 += n17), 12);
            n17 = ChaChaEngine.rotl(n17 ^ (n5 += n9), 8);
            n9 = ChaChaEngine.rotl(n9 ^ (n13 += n17), 7);
            n18 = ChaChaEngine.rotl(n18 ^ (n6 += n10), 16);
            n10 = ChaChaEngine.rotl(n10 ^ (n14 += n18), 12);
            n18 = ChaChaEngine.rotl(n18 ^ (n6 += n10), 8);
            n10 = ChaChaEngine.rotl(n10 ^ (n14 += n18), 7);
            n18 = ChaChaEngine.rotl(n18 ^ (n3 += n8), 16);
            n8 = ChaChaEngine.rotl(n8 ^ (n13 += n18), 12);
            n18 = ChaChaEngine.rotl(n18 ^ (n3 += n8), 8);
            n8 = ChaChaEngine.rotl(n8 ^ (n13 += n18), 7);
            n15 = ChaChaEngine.rotl(n15 ^ (n4 += n9), 16);
            n9 = ChaChaEngine.rotl(n9 ^ (n14 += n15), 12);
            n15 = ChaChaEngine.rotl(n15 ^ (n4 += n9), 8);
            n9 = ChaChaEngine.rotl(n9 ^ (n14 += n15), 7);
            n16 = ChaChaEngine.rotl(n16 ^ (n5 += n10), 16);
            n10 = ChaChaEngine.rotl(n10 ^ (n11 += n16), 12);
            n16 = ChaChaEngine.rotl(n16 ^ (n5 += n10), 8);
            n10 = ChaChaEngine.rotl(n10 ^ (n11 += n16), 7);
            n17 = ChaChaEngine.rotl(n17 ^ (n6 += n7), 16);
            n7 = ChaChaEngine.rotl(n7 ^ (n12 += n17), 12);
            n17 = ChaChaEngine.rotl(n17 ^ (n6 += n7), 8);
            n7 = ChaChaEngine.rotl(n7 ^ (n12 += n17), 7);
        }
        nArray2[0] = n3 + nArray[0];
        nArray2[1] = n4 + nArray[1];
        nArray2[2] = n5 + nArray[2];
        nArray2[3] = n6 + nArray[3];
        nArray2[4] = n7 + nArray[4];
        nArray2[5] = n8 + nArray[5];
        nArray2[6] = n9 + nArray[6];
        nArray2[7] = n10 + nArray[7];
        nArray2[8] = n11 + nArray[8];
        nArray2[9] = n12 + nArray[9];
        nArray2[10] = n13 + nArray[10];
        nArray2[11] = n14 + nArray[11];
        nArray2[12] = n15 + nArray[12];
        nArray2[13] = n16 + nArray[13];
        nArray2[14] = n17 + nArray[14];
        nArray2[15] = n18 + nArray[15];
    }
}

