/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tgtext.bouncycastle.util.io.pem;

import com.timevale.esign.paas.tgtext.bouncycastle.util.Strings;
import com.timevale.esign.paas.tgtext.bouncycastle.util.encoders.Base64;
import com.timevale.esign.paas.tgtext.bouncycastle.util.io.pem.PemHeader;
import com.timevale.esign.paas.tgtext.bouncycastle.util.io.pem.PemObject;
import com.timevale.esign.paas.tgtext.bouncycastle.util.io.pem.PemObjectGenerator;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;

public class PemWriter
extends BufferedWriter {
    private static final int LINE_LENGTH = 64;
    private final int nlLength;
    private char[] buf = new char[64];

    public PemWriter(Writer writer) {
        super(writer);
        String string = Strings.lineSeparator();
        this.nlLength = string != null ? string.length() : 2;
    }

    public int getOutputSize(PemObject pemObject) {
        int n2 = 2 * (pemObject.getType().length() + 10 + this.nlLength) + 6 + 4;
        if (!pemObject.getHeaders().isEmpty()) {
            for (PemHeader pemHeader : pemObject.getHeaders()) {
                n2 += pemHeader.getName().length() + ": ".length() + pemHeader.getValue().length() + this.nlLength;
            }
            n2 += this.nlLength;
        }
        int n3 = (pemObject.getContent().length + 2) / 3 * 4;
        return n2 += n3 + (n3 + 64 - 1) / 64 * this.nlLength;
    }

    public void writeObject(PemObjectGenerator pemObjectGenerator) throws IOException {
        PemObject pemObject = pemObjectGenerator.generate();
        this.writePreEncapsulationBoundary(pemObject.getType());
        if (!pemObject.getHeaders().isEmpty()) {
            for (PemHeader pemHeader : pemObject.getHeaders()) {
                this.write(pemHeader.getName());
                this.write(": ");
                this.write(pemHeader.getValue());
                this.newLine();
            }
            this.newLine();
        }
        this.writeEncoded(pemObject.getContent());
        this.writePostEncapsulationBoundary(pemObject.getType());
    }

    private void writeEncoded(byte[] byArray) throws IOException {
        byArray = Base64.encode(byArray);
        for (int i2 = 0; i2 < byArray.length; i2 += this.buf.length) {
            int n2;
            for (n2 = 0; n2 != this.buf.length && i2 + n2 < byArray.length; ++n2) {
                this.buf[n2] = (char)byArray[i2 + n2];
            }
            this.write(this.buf, 0, n2);
            this.newLine();
        }
    }

    private void writePreEncapsulationBoundary(String string) throws IOException {
        this.write("-----BEGIN " + string + "-----");
        this.newLine();
    }

    private void writePostEncapsulationBoundary(String string) throws IOException {
        this.write("-----END " + string + "-----");
        this.newLine();
    }
}

