/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tgtext.text.pdf.f;

public final class a {
    public int[] bits;
    public final int size;

    public a(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("size must be at least 1");
        }
        this.size = n2;
        this.bits = a.makeArray(n2);
    }

    public int getSize() {
        return this.size;
    }

    public boolean get(int i2) {
        return (this.bits[i2 >> 5] & 1 << (i2 & 0x1F)) != 0;
    }

    public void set(int i2) {
        int n2 = i2 >> 5;
        this.bits[n2] = this.bits[n2] | 1 << (i2 & 0x1F);
    }

    public void flip(int i2) {
        int n2 = i2 >> 5;
        this.bits[n2] = this.bits[n2] ^ 1 << (i2 & 0x1F);
    }

    public void setBulk(int i2, int newBits) {
        this.bits[i2 >> 5] = newBits;
    }

    public void clear() {
        int n2 = this.bits.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.bits[i2] = 0;
        }
    }

    public boolean isRange(int start, int end, boolean value) {
        if (end < start) {
            throw new IllegalArgumentException();
        }
        if (end == start) {
            return true;
        }
        int n2 = start >> 5;
        int n3 = --end >> 5;
        for (int i2 = n2; i2 <= n3; ++i2) {
            int n4;
            int n5;
            int n6 = i2 > n2 ? 0 : start & 0x1F;
            int n7 = n5 = i2 < n3 ? 31 : end & 0x1F;
            if (n6 == 0 && n5 == 31) {
                n4 = -1;
            } else {
                n4 = 0;
                for (int i3 = n6; i3 <= n5; ++i3) {
                    n4 |= 1 << i3;
                }
            }
            if ((this.bits[i2] & n4) == (value ? n4 : 0)) continue;
            return false;
        }
        return true;
    }

    public int[] getBitArray() {
        return this.bits;
    }

    public void reverse() {
        int[] nArray = new int[this.bits.length];
        int n2 = this.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!this.get(n2 - i2 - 1)) continue;
            int n3 = i2 >> 5;
            nArray[n3] = nArray[n3] | 1 << (i2 & 0x1F);
        }
        this.bits = nArray;
    }

    private static int[] makeArray(int size) {
        int n2 = size >> 5;
        if ((size & 0x1F) != 0) {
            ++n2;
        }
        return new int[n2];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.size);
        for (int i2 = 0; i2 < this.size; ++i2) {
            if ((i2 & 7) == 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(this.get(i2) ? (char)'X' : '.');
        }
        return stringBuffer.toString();
    }
}

