/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.esign.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Base64 {
    private static Logger LOGGER;
    private static final int BASELENGTH = 255;
    private static final int LOOKUPLENGTH = 64;
    private static final int TWENTYFOURBITGROUP = 24;
    private static final int EIGHTBIT = 8;
    private static final int SIXTEENBIT = 16;
    private static final int FOURBYTE = 4;
    private static final int SIGN = -128;
    private static final char PAD = '=';
    private static final boolean fDebug = false;
    private static final byte[] base64Alphabet;
    private static final char[] lookUpBase64Alphabet;

    protected static boolean isWhiteSpace(char octect) {
        return octect == ' ' || octect == '\r' || octect == '\n' || octect == '\t';
    }

    protected static boolean isPad(char octect) {
        return octect == '=';
    }

    protected static boolean isData(char octect) {
        return base64Alphabet[octect] != -1;
    }

    protected static boolean isBase64(char octect) {
        return Base64.isWhiteSpace(octect) || Base64.isPad(octect) || Base64.isData(octect);
    }

    public static String encode(byte[] binaryData) {
        byte by2;
        int n2;
        int n3;
        if (binaryData == null) {
            return null;
        }
        int n4 = binaryData.length * 8;
        if (n4 == 0) {
            return "";
        }
        int n5 = n4 % 24;
        int n6 = n4 / 24;
        int n7 = n5 != 0 ? n6 + 1 : n6;
        int n8 = 1;
        char[] cArray = null;
        cArray = new char[n7 * 4 + n8];
        byte by3 = 0;
        byte by4 = 0;
        byte by5 = 0;
        byte by6 = 0;
        byte by7 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        for (n3 = 0; n3 < n8 - 1; ++n3) {
            for (n2 = 0; n2 < 16; ++n2) {
                by5 = binaryData[n10++];
                by6 = binaryData[n10++];
                by7 = binaryData[n10++];
                by4 = (byte)(by6 & 0xF);
                by3 = (byte)(by5 & 3);
                by2 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 2) : (byte)(by5 >> 2 ^ 0xC0);
                byte by8 = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 4) : (byte)(by6 >> 4 ^ 0xF0);
                byte by9 = (by7 & 0xFFFFFF80) == 0 ? (byte)(by7 >> 6) : (byte)(by7 >> 6 ^ 0xFC);
                cArray[n9++] = lookUpBase64Alphabet[by2];
                cArray[n9++] = lookUpBase64Alphabet[by8 | by3 << 4];
                cArray[n9++] = lookUpBase64Alphabet[by4 << 2 | by9];
                cArray[n9++] = lookUpBase64Alphabet[by7 & 0x3F];
                ++n11;
            }
            cArray[n9++] = 10;
        }
        while (n11 < n6) {
            by5 = binaryData[n10++];
            by6 = binaryData[n10++];
            by7 = binaryData[n10++];
            by4 = (byte)(by6 & 0xF);
            by3 = (byte)(by5 & 3);
            n3 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 2) : (byte)(by5 >> 2 ^ 0xC0);
            n2 = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 4) : (byte)(by6 >> 4 ^ 0xF0);
            by2 = (by7 & 0xFFFFFF80) == 0 ? (byte)(by7 >> 6) : (byte)(by7 >> 6 ^ 0xFC);
            cArray[n9++] = lookUpBase64Alphabet[n3];
            cArray[n9++] = lookUpBase64Alphabet[n2 | by3 << 4];
            cArray[n9++] = lookUpBase64Alphabet[by4 << 2 | by2];
            cArray[n9++] = lookUpBase64Alphabet[by7 & 0x3F];
            ++n11;
        }
        if (n5 == 8) {
            by5 = binaryData[n10];
            by3 = (byte)(by5 & 3);
            n3 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 2) : (byte)(by5 >> 2 ^ 0xC0);
            cArray[n9++] = lookUpBase64Alphabet[n3];
            cArray[n9++] = lookUpBase64Alphabet[by3 << 4];
            cArray[n9++] = 61;
            cArray[n9++] = 61;
        } else if (n5 == 16) {
            by5 = binaryData[n10];
            by6 = binaryData[n10 + 1];
            by4 = (byte)(by6 & 0xF);
            by3 = (byte)(by5 & 3);
            n3 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 2) : (byte)(by5 >> 2 ^ 0xC0);
            n2 = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 4) : (byte)(by6 >> 4 ^ 0xF0);
            cArray[n9++] = lookUpBase64Alphabet[n3];
            cArray[n9++] = lookUpBase64Alphabet[n2 | by3 << 4];
            cArray[n9++] = lookUpBase64Alphabet[by4 << 2];
            cArray[n9++] = 61;
        }
        cArray[n9] = 10;
        return new String(cArray);
    }

    public static String encode(byte[] binaryData, char end) {
        byte by2;
        int n2;
        int n3;
        if (binaryData == null) {
            return null;
        }
        int n4 = binaryData.length * 8;
        if (n4 == 0) {
            return "";
        }
        int n5 = n4 % 24;
        int n6 = n4 / 24;
        int n7 = n5 != 0 ? n6 + 1 : n6;
        int n8 = '\u0000' == end ? 0 : 1;
        char[] cArray = null;
        cArray = new char[n7 * 4 + n8];
        byte by3 = 0;
        byte by4 = 0;
        byte by5 = 0;
        byte by6 = 0;
        byte by7 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        for (n3 = 0; n3 < n8 - 1; ++n3) {
            for (n2 = 0; n2 < 16; ++n2) {
                by5 = binaryData[n10++];
                by6 = binaryData[n10++];
                by7 = binaryData[n10++];
                by4 = (byte)(by6 & 0xF);
                by3 = (byte)(by5 & 3);
                by2 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 2) : (byte)(by5 >> 2 ^ 0xC0);
                byte by8 = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 4) : (byte)(by6 >> 4 ^ 0xF0);
                byte by9 = (by7 & 0xFFFFFF80) == 0 ? (byte)(by7 >> 6) : (byte)(by7 >> 6 ^ 0xFC);
                cArray[n9++] = lookUpBase64Alphabet[by2];
                cArray[n9++] = lookUpBase64Alphabet[by8 | by3 << 4];
                cArray[n9++] = lookUpBase64Alphabet[by4 << 2 | by9];
                cArray[n9++] = lookUpBase64Alphabet[by7 & 0x3F];
                ++n11;
            }
            cArray[n9++] = 10;
        }
        while (n11 < n6) {
            by5 = binaryData[n10++];
            by6 = binaryData[n10++];
            by7 = binaryData[n10++];
            by4 = (byte)(by6 & 0xF);
            by3 = (byte)(by5 & 3);
            n3 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 2) : (byte)(by5 >> 2 ^ 0xC0);
            n2 = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 4) : (byte)(by6 >> 4 ^ 0xF0);
            by2 = (by7 & 0xFFFFFF80) == 0 ? (byte)(by7 >> 6) : (byte)(by7 >> 6 ^ 0xFC);
            cArray[n9++] = lookUpBase64Alphabet[n3];
            cArray[n9++] = lookUpBase64Alphabet[n2 | by3 << 4];
            cArray[n9++] = lookUpBase64Alphabet[by4 << 2 | by2];
            cArray[n9++] = lookUpBase64Alphabet[by7 & 0x3F];
            ++n11;
        }
        if (n5 == 8) {
            by5 = binaryData[n10];
            by3 = (byte)(by5 & 3);
            n3 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 2) : (byte)(by5 >> 2 ^ 0xC0);
            cArray[n9++] = lookUpBase64Alphabet[n3];
            cArray[n9++] = lookUpBase64Alphabet[by3 << 4];
            cArray[n9++] = 61;
            cArray[n9++] = 61;
        } else if (n5 == 16) {
            by5 = binaryData[n10];
            by6 = binaryData[n10 + 1];
            by4 = (byte)(by6 & 0xF);
            by3 = (byte)(by5 & 3);
            n3 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 2) : (byte)(by5 >> 2 ^ 0xC0);
            n2 = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 4) : (byte)(by6 >> 4 ^ 0xF0);
            cArray[n9++] = lookUpBase64Alphabet[n3];
            cArray[n9++] = lookUpBase64Alphabet[n2 | by3 << 4];
            cArray[n9++] = lookUpBase64Alphabet[by4 << 2];
            cArray[n9++] = 61;
        }
        if ('\u0000' != end) {
            cArray[n9] = end;
        }
        return new String(cArray);
    }

    public static byte[] decode(String encoded) {
        int n2;
        if (encoded == null) {
            return null;
        }
        char[] cArray = encoded.toCharArray();
        int n3 = Base64.removeWhiteSpace(cArray);
        if (n3 % 4 != 0) {
            return null;
        }
        int n4 = n3 / 4;
        if (n4 == 0) {
            return new byte[0];
        }
        byte[] byArray = null;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        byte by5 = 0;
        char c2 = '\u0000';
        char c3 = '\u0000';
        char c4 = '\u0000';
        char c5 = '\u0000';
        int n5 = 0;
        int n6 = 0;
        byArray = new byte[n4 * 3];
        for (n2 = 0; n2 < n4 - 1; ++n2) {
            if (!(Base64.isData(c2 = cArray[n6++]) && Base64.isData(c3 = cArray[n6++]) && Base64.isData(c4 = cArray[n6++]) && Base64.isData(c5 = cArray[n6++]))) {
                return null;
            }
            by2 = base64Alphabet[c2];
            by3 = base64Alphabet[c3];
            by4 = base64Alphabet[c4];
            by5 = base64Alphabet[c5];
            byArray[n5++] = (byte)(by2 << 2 | by3 >> 4);
            byArray[n5++] = (byte)((by3 & 0xF) << 4 | by4 >> 2 & 0xF);
            byArray[n5++] = (byte)(by4 << 6 | by5);
        }
        if (!Base64.isData(c2 = cArray[n6++]) || !Base64.isData(c3 = cArray[n6++])) {
            return null;
        }
        by2 = base64Alphabet[c2];
        by3 = base64Alphabet[c3];
        c4 = cArray[n6++];
        c5 = cArray[n6++];
        if (!Base64.isData(c4) || !Base64.isData(c5)) {
            if (Base64.isPad(c4) && Base64.isPad(c5)) {
                if ((by3 & 0xF) != 0) {
                    return null;
                }
                byte[] byArray2 = new byte[n2 * 3 + 1];
                System.arraycopy(byArray, 0, byArray2, 0, n2 * 3);
                byArray2[n5] = (byte)(by2 << 2 | by3 >> 4);
                return byArray2;
            }
            if (!Base64.isPad(c4) && Base64.isPad(c5)) {
                by4 = base64Alphabet[c4];
                if ((by4 & 3) != 0) {
                    return null;
                }
                byte[] byArray3 = new byte[n2 * 3 + 2];
                System.arraycopy(byArray, 0, byArray3, 0, n2 * 3);
                byArray3[n5++] = (byte)(by2 << 2 | by3 >> 4);
                byArray3[n5] = (byte)((by3 & 0xF) << 4 | by4 >> 2 & 0xF);
                return byArray3;
            }
            return null;
        }
        by4 = base64Alphabet[c4];
        by5 = base64Alphabet[c5];
        byArray[n5++] = (byte)(by2 << 2 | by3 >> 4);
        byArray[n5++] = (byte)((by3 & 0xF) << 4 | by4 >> 2 & 0xF);
        byArray[n5++] = (byte)(by4 << 6 | by5);
        return byArray;
    }

    public static String encode(File file) {
        byte[] byArray;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            byArray = new byte[(int)file.length()];
            fileInputStream.read(byArray);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            LOGGER.error("read file failed.", (Throwable)iOException);
            return null;
        }
        return Base64.encode(byArray);
    }

    protected static int removeWhiteSpace(char[] data) {
        if (data == null) {
            return 0;
        }
        int n2 = 0;
        int n3 = data.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (Base64.isWhiteSpace(data[i2])) continue;
            data[n2++] = data[i2];
        }
        return n2;
    }

    public static void main(String[] args) {
        String string = "qwertyuiopaaa";
        String string2 = "";
        int n2 = 13;
        System.out.println(n2 / 3);
        System.out.println(n2 % 3);
        int n3 = 0;
        for (n3 = 0; n3 < 4; ++n3) {
            string2 = string2 + string.substring(n3 * 3, n3 * 3 + 3) + "\n";
        }
        if (n2 % 3 != 0) {
            string2 = string2 + string.substring(n3 * 3, string.length()) + "\n";
        }
        System.out.print(string2);
    }

    static {
        int n2;
        LOGGER = LoggerFactory.getLogger(Base64.class);
        base64Alphabet = new byte[255];
        lookUpBase64Alphabet = new char[64];
        for (n2 = 0; n2 < 255; ++n2) {
            Base64.base64Alphabet[n2] = -1;
        }
        for (n2 = 90; n2 >= 65; --n2) {
            Base64.base64Alphabet[n2] = (byte)(n2 - 65);
        }
        for (n2 = 122; n2 >= 97; --n2) {
            Base64.base64Alphabet[n2] = (byte)(n2 - 97 + 26);
        }
        for (n2 = 57; n2 >= 48; --n2) {
            Base64.base64Alphabet[n2] = (byte)(n2 - 48 + 52);
        }
        Base64.base64Alphabet[43] = 62;
        Base64.base64Alphabet[47] = 63;
        for (n2 = 0; n2 <= 25; ++n2) {
            Base64.lookUpBase64Alphabet[n2] = (char)(65 + n2);
        }
        n2 = 26;
        int n3 = 0;
        while (n2 <= 51) {
            Base64.lookUpBase64Alphabet[n2] = (char)(97 + n3);
            ++n2;
            ++n3;
        }
        n2 = 52;
        n3 = 0;
        while (n2 <= 61) {
            Base64.lookUpBase64Alphabet[n2] = (char)(48 + n3);
            ++n2;
            ++n3;
        }
        Base64.lookUpBase64Alphabet[62] = 43;
        Base64.lookUpBase64Alphabet[63] = 47;
    }
}

