/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.esign.utils.constant.type;

public enum AccountStatus {
    Invalid(0),
    NotSubmit(1),
    Submitted(2),
    Reject(3),
    WaitRemit(4),
    Remitted(5),
    HalfRealName(8),
    RealName(9),
    HalfRealNameSubmitted(12),
    HalfRealNameReject(13),
    HalfRealNameWaitRemit(14),
    HalfRealNameRemitted(15);

    private int status;

    private AccountStatus(int status) {
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public static AccountStatus getEnum(int status) {
        for (AccountStatus accountStatus : AccountStatus.values()) {
            if (accountStatus.getStatus() != status) continue;
            return accountStatus;
        }
        return Invalid;
    }

    public static boolean isHalfReal(int status) {
        AccountStatus accountStatus = AccountStatus.getEnum(status);
        switch (accountStatus) {
            case HalfRealName: 
            case HalfRealNameSubmitted: 
            case HalfRealNameReject: 
            case HalfRealNameWaitRemit: 
            case HalfRealNameRemitted: {
                return true;
            }
        }
        return false;
    }
}

