/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.esign.utils.security.cipher;

import com.timevale.esign.paas.esign.utils.exception.SuperException;
import com.timevale.esign.paas.esign.utils.security.cipher.impl.ISignerProviderFactory;
import com.timevale.esign.paas.esign.utils.security.cipher.impl.ISimSignerProvider;
import com.timevale.esign.paas.esign.utils.security.cipher.impl.adapter.DigestMacModelAdapter;
import com.timevale.esign.paas.esign.utils.security.cipher.impl.adapter.DigestModelAdapter;
import com.timevale.esign.paas.esign.utils.security.cipher.impl.sign.hmac.HmacDigestProvider;
import com.timevale.esign.paas.esign.utils.security.model.DigestAlgorithmModel;

public enum MacSignerProviderFactory {
    HMAC{

        @Override
        protected ISimSignerProvider create(String algorithmFully) throws SuperException {
            return new HmacDigestProvider(algorithmFully);
        }
    };


    public ISignerProviderFactory factory(DigestAlgorithmModel digestAlg) {
        String string = this.discription(digestAlg);
        return new SignerProviderFactory(this, string);
    }

    private String discription(DigestAlgorithmModel digestAlg) {
        return DigestMacModelAdapter.HMAC.algorithm() + DigestModelAdapter.from(digestAlg).algorithm();
    }

    protected abstract ISimSignerProvider create(String var1) throws SuperException;

    private class SignerProviderFactory
    implements ISignerProviderFactory {
        private String algorithmFully;
        private MacSignerProviderFactory factory;

        protected SignerProviderFactory(MacSignerProviderFactory factory, String algorithmFully) {
            this.algorithmFully = algorithmFully;
            this.factory = factory;
        }

        @Override
        public ISimSignerProvider create() throws SuperException {
            return this.factory.create(this.algorithmFully);
        }
    }
}

