/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.esign.utils.security.cipher.impl.sign.hmac;

import com.timevale.esign.paas.esign.utils.exception.ErrorsDiscriptor;
import com.timevale.esign.paas.esign.utils.exception.SuperException;
import com.timevale.esign.paas.esign.utils.security.cipher.impl.ISimSignerProvider;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HmacDigestProvider
implements ISimSignerProvider {
    private Key secKey;
    private Mac mac;
    private static final Logger LOGGER = LoggerFactory.getLogger(HmacDigestProvider.class);

    public HmacDigestProvider(String algorithmFully) throws SuperException {
        this.mac = this.createMac(algorithmFully);
    }

    @Override
    public ISimSignerProvider init(String key) throws SuperException {
        return this.init(key.getBytes());
    }

    @Override
    public ISimSignerProvider init(byte[] key) throws SuperException {
        this.secKey = new SecretKeySpec(key, this.mac.getAlgorithm());
        return this;
    }

    @Override
    public byte[] sign(byte[] data) throws SuperException {
        try {
            this.mac.init(this.secKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            LOGGER.error("init mac cipher failed.", (Throwable)invalidKeyException);
            throw ErrorsDiscriptor.InvalidCipherKey.e();
        }
        return this.mac.doFinal(data);
    }

    @Override
    public boolean verify(byte[] data, byte[] signature) throws SuperException {
        return Arrays.equals(signature, this.sign(data));
    }

    private Mac createMac(String algorithm) throws SuperException {
        try {
            return Mac.getInstance(algorithm);
        }
        catch (Exception exception) {
            LOGGER.error("create ciphter failed. algorithm:{}", (Object)algorithm);
            LOGGER.error("exception:", (Throwable)exception);
            throw ErrorsDiscriptor.InvalidCipherAlgorithm.e(exception);
        }
    }
}

