/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.esign.utils.security.provider;

import com.timevale.esign.paas.esign.utils.StringUtil;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertPathValidator;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;

public enum SecurityProvider {
    Default("");

    private CertificateFactory factory;
    private CertPathValidator validator;

    private SecurityProvider(String provider) {
        try {
            if (!StringUtil.isNull(provider)) {
                this.factory = CertificateFactory.getInstance("X.509", provider);
                this.validator = CertPathValidator.getInstance("PKIX", provider);
            } else {
                this.factory = CertificateFactory.getInstance("X.509");
                this.validator = CertPathValidator.getInstance("PKIX");
            }
        }
        catch (CertificateException certificateException) {
            certificateException.printStackTrace();
        }
        catch (NoSuchProviderException noSuchProviderException) {
            noSuchProviderException.printStackTrace();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
    }

    public CertificateFactory factory() {
        return this.factory;
    }

    public CertPathValidator validator() {
        return this.validator;
    }
}

