/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.base;

import com.timevale.esign.paas.guava.common.annotations.Beta;
import com.timevale.esign.paas.guava.common.annotations.GwtCompatible;
import com.timevale.esign.paas.guava.common.base.Platform;
import com.timevale.esign.paas.guava.common.base.Preconditions;
import com.timevale.esign.paas.guava.common.base.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckReturnValue;

@Beta
@GwtCompatible
public abstract class CharMatcher
implements Predicate<Character> {
    private static final String BREAKING_WHITESPACE_CHARS = "\t\n\u000b\f\r \u0085\u1680\u2028\u2029\u205f\u3000";
    private static final String NON_BREAKING_WHITESPACE_CHARS = "\u00a0\u180e\u202f";
    public static final CharMatcher WHITESPACE = CharMatcher.anyOf("\t\n\u000b\f\r \u0085\u1680\u2028\u2029\u205f\u3000\u00a0\u180e\u202f").or(CharMatcher.inRange('\u2000', '\u200a')).precomputed();
    public static final CharMatcher BREAKING_WHITESPACE = CharMatcher.anyOf("\t\n\u000b\f\r \u0085\u1680\u2028\u2029\u205f\u3000").or(CharMatcher.inRange('\u2000', '\u2006')).or(CharMatcher.inRange('\u2008', '\u200a')).precomputed();
    public static final CharMatcher ASCII = CharMatcher.inRange('\u0000', '\u007f');
    public static final CharMatcher DIGIT;
    public static final CharMatcher JAVA_WHITESPACE;
    public static final CharMatcher JAVA_DIGIT;
    public static final CharMatcher JAVA_LETTER;
    public static final CharMatcher JAVA_LETTER_OR_DIGIT;
    public static final CharMatcher JAVA_UPPER_CASE;
    public static final CharMatcher JAVA_LOWER_CASE;
    public static final CharMatcher JAVA_ISO_CONTROL;
    public static final CharMatcher INVISIBLE;
    public static final CharMatcher SINGLE_WIDTH;
    public static final CharMatcher ANY;
    public static final CharMatcher NONE;

    public static CharMatcher is(final char match) {
        return new CharMatcher(){

            @Override
            public boolean matches(char c2) {
                return c2 == match;
            }

            @Override
            public String replaceFrom(CharSequence sequence, char replacement) {
                return ((Object)sequence).toString().replace(match, replacement);
            }

            @Override
            public CharMatcher and(CharMatcher other) {
                return other.matches(match) ? this : NONE;
            }

            @Override
            public CharMatcher or(CharMatcher other) {
                return other.matches(match) ? other : super.or(other);
            }

            @Override
            public CharMatcher negate() {
                return 8.isNot(match);
            }

            @Override
            void setBits(LookupTable table) {
                table.set(match);
            }

            @Override
            public CharMatcher precomputed() {
                return this;
            }
        };
    }

    public static CharMatcher isNot(final char match) {
        return new CharMatcher(){

            @Override
            public boolean matches(char c2) {
                return c2 != match;
            }

            @Override
            public CharMatcher and(CharMatcher other) {
                return other.matches(match) ? super.and(other) : other;
            }

            @Override
            public CharMatcher or(CharMatcher other) {
                return other.matches(match) ? ANY : this;
            }

            @Override
            public CharMatcher negate() {
                return 9.is(match);
            }
        };
    }

    public static CharMatcher anyOf(CharSequence sequence) {
        switch (sequence.length()) {
            case 0: {
                return NONE;
            }
            case 1: {
                return CharMatcher.is(sequence.charAt(0));
            }
            case 2: {
                final char c2 = sequence.charAt(0);
                final char c3 = sequence.charAt(1);
                return new CharMatcher(){

                    @Override
                    public boolean matches(char c22) {
                        return c22 == c2 || c22 == c3;
                    }

                    @Override
                    void setBits(LookupTable table) {
                        table.set(c2);
                        table.set(c3);
                    }

                    @Override
                    public CharMatcher precomputed() {
                        return this;
                    }
                };
            }
        }
        final char[] cArray = ((Object)sequence).toString().toCharArray();
        Arrays.sort(cArray);
        return new CharMatcher(){

            @Override
            public boolean matches(char c2) {
                return Arrays.binarySearch(cArray, c2) >= 0;
            }

            @Override
            void setBits(LookupTable table) {
                for (char c2 : cArray) {
                    table.set(c2);
                }
            }
        };
    }

    public static CharMatcher noneOf(CharSequence sequence) {
        return CharMatcher.anyOf(sequence).negate();
    }

    public static CharMatcher inRange(final char startInclusive, final char endInclusive) {
        Preconditions.checkArgument(endInclusive >= startInclusive);
        return new CharMatcher(){

            @Override
            public boolean matches(char c2) {
                return startInclusive <= c2 && c2 <= endInclusive;
            }

            @Override
            void setBits(LookupTable table) {
                char c2;
                char c3 = startInclusive;
                do {
                    table.set(c3);
                    c2 = c3;
                    c3 = (char)(c3 + '\u0001');
                } while (c2 != endInclusive);
            }

            @Override
            public CharMatcher precomputed() {
                return this;
            }
        };
    }

    public static CharMatcher forPredicate(final Predicate<? super Character> predicate) {
        Preconditions.checkNotNull(predicate);
        if (predicate instanceof CharMatcher) {
            return (CharMatcher)predicate;
        }
        return new CharMatcher(){

            @Override
            public boolean matches(char c2) {
                return predicate.apply(Character.valueOf(c2));
            }

            @Override
            public boolean apply(Character character) {
                return predicate.apply(Preconditions.checkNotNull(character));
            }
        };
    }

    public abstract boolean matches(char var1);

    public CharMatcher negate() {
        final CharMatcher charMatcher = this;
        return new CharMatcher(){

            @Override
            public boolean matches(char c2) {
                return !charMatcher.matches(c2);
            }

            @Override
            public boolean matchesAllOf(CharSequence sequence) {
                return charMatcher.matchesNoneOf(sequence);
            }

            @Override
            public boolean matchesNoneOf(CharSequence sequence) {
                return charMatcher.matchesAllOf(sequence);
            }

            @Override
            public int countIn(CharSequence sequence) {
                return sequence.length() - charMatcher.countIn(sequence);
            }

            @Override
            public CharMatcher negate() {
                return charMatcher;
            }
        };
    }

    public CharMatcher and(CharMatcher other) {
        return new And(Arrays.asList(this, Preconditions.checkNotNull(other)));
    }

    public CharMatcher or(CharMatcher other) {
        return new Or(Arrays.asList(this, Preconditions.checkNotNull(other)));
    }

    public CharMatcher precomputed() {
        return Platform.precomputeCharMatcher(this);
    }

    CharMatcher precomputedInternal() {
        final LookupTable lookupTable = new LookupTable();
        this.setBits(lookupTable);
        return new CharMatcher(){

            @Override
            public boolean matches(char c2) {
                return lookupTable.get(c2);
            }

            @Override
            public CharMatcher precomputed() {
                return this;
            }
        };
    }

    void setBits(LookupTable table) {
        char c2;
        char c3 = '\u0000';
        do {
            if (this.matches(c3)) {
                table.set(c3);
            }
            c2 = c3;
            c3 = (char)(c3 + '\u0001');
        } while (c2 != 65535);
    }

    public boolean matchesAnyOf(CharSequence sequence) {
        return !this.matchesNoneOf(sequence);
    }

    public boolean matchesAllOf(CharSequence sequence) {
        for (int i2 = sequence.length() - 1; i2 >= 0; --i2) {
            if (this.matches(sequence.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public boolean matchesNoneOf(CharSequence sequence) {
        return this.indexIn(sequence) == -1;
    }

    public int indexIn(CharSequence sequence) {
        int n2 = sequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!this.matches(sequence.charAt(i2))) continue;
            return i2;
        }
        return -1;
    }

    public int indexIn(CharSequence sequence, int start) {
        int n2 = sequence.length();
        Preconditions.checkPositionIndex(start, n2);
        for (int i2 = start; i2 < n2; ++i2) {
            if (!this.matches(sequence.charAt(i2))) continue;
            return i2;
        }
        return -1;
    }

    public int lastIndexIn(CharSequence sequence) {
        for (int i2 = sequence.length() - 1; i2 >= 0; --i2) {
            if (!this.matches(sequence.charAt(i2))) continue;
            return i2;
        }
        return -1;
    }

    public int countIn(CharSequence sequence) {
        int n2 = 0;
        for (int i2 = 0; i2 < sequence.length(); ++i2) {
            if (!this.matches(sequence.charAt(i2))) continue;
            ++n2;
        }
        return n2;
    }

    @CheckReturnValue
    public String removeFrom(CharSequence sequence) {
        String string = ((Object)sequence).toString();
        int n2 = this.indexIn(string);
        if (n2 == -1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n3 = 1;
        block0: while (true) {
            ++n2;
            while (n2 != cArray.length) {
                if (!this.matches(cArray[n2])) {
                    cArray[n2 - n3] = cArray[n2];
                    ++n2;
                    continue;
                }
                ++n3;
                continue block0;
            }
            break;
        }
        return new String(cArray, 0, n2 - n3);
    }

    @CheckReturnValue
    public String retainFrom(CharSequence sequence) {
        return this.negate().removeFrom(sequence);
    }

    @CheckReturnValue
    public String replaceFrom(CharSequence sequence, char replacement) {
        String string = ((Object)sequence).toString();
        int n2 = this.indexIn(string);
        if (n2 == -1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[n2] = replacement;
        for (int i2 = n2 + 1; i2 < cArray.length; ++i2) {
            if (!this.matches(cArray[i2])) continue;
            cArray[i2] = replacement;
        }
        return new String(cArray);
    }

    @CheckReturnValue
    public String replaceFrom(CharSequence sequence, CharSequence replacement) {
        int n2 = replacement.length();
        if (n2 == 0) {
            return this.removeFrom(sequence);
        }
        if (n2 == 1) {
            return this.replaceFrom(sequence, replacement.charAt(0));
        }
        String string = ((Object)sequence).toString();
        int n3 = this.indexIn(string);
        if (n3 == -1) {
            return string;
        }
        int n4 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n4 * 3 / 2 + 16);
        int n5 = 0;
        do {
            stringBuilder.append(string, n5, n3);
            stringBuilder.append(replacement);
        } while ((n3 = this.indexIn(string, n5 = n3 + 1)) != -1);
        stringBuilder.append(string, n5, n4);
        return stringBuilder.toString();
    }

    @CheckReturnValue
    public String trimFrom(CharSequence sequence) {
        int n2;
        int n3;
        int n4 = sequence.length();
        for (n3 = 0; n3 < n4 && this.matches(sequence.charAt(n3)); ++n3) {
        }
        for (n2 = n4 - 1; n2 > n3 && this.matches(sequence.charAt(n2)); --n2) {
        }
        return ((Object)sequence.subSequence(n3, n2 + 1)).toString();
    }

    @CheckReturnValue
    public String trimLeadingFrom(CharSequence sequence) {
        int n2;
        int n3 = sequence.length();
        for (n2 = 0; n2 < n3 && this.matches(sequence.charAt(n2)); ++n2) {
        }
        return ((Object)sequence.subSequence(n2, n3)).toString();
    }

    @CheckReturnValue
    public String trimTrailingFrom(CharSequence sequence) {
        int n2;
        int n3 = sequence.length();
        for (n2 = n3 - 1; n2 >= 0 && this.matches(sequence.charAt(n2)); --n2) {
        }
        return ((Object)sequence.subSequence(0, n2 + 1)).toString();
    }

    @CheckReturnValue
    public String collapseFrom(CharSequence sequence, char replacement) {
        int n2 = this.indexIn(sequence);
        if (n2 == -1) {
            return ((Object)sequence).toString();
        }
        StringBuilder stringBuilder = new StringBuilder(sequence.length()).append(sequence.subSequence(0, n2)).append(replacement);
        boolean bl2 = true;
        for (int i2 = n2 + 1; i2 < sequence.length(); ++i2) {
            char c2 = sequence.charAt(i2);
            if (this.apply(Character.valueOf(c2))) {
                if (bl2) continue;
                stringBuilder.append(replacement);
                bl2 = true;
                continue;
            }
            stringBuilder.append(c2);
            bl2 = false;
        }
        return stringBuilder.toString();
    }

    @CheckReturnValue
    public String trimAndCollapseFrom(CharSequence sequence, char replacement) {
        int n2 = this.negate().indexIn(sequence);
        if (n2 == -1) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(sequence.length());
        boolean bl2 = false;
        for (int i2 = n2; i2 < sequence.length(); ++i2) {
            char c2 = sequence.charAt(i2);
            if (this.apply(Character.valueOf(c2))) {
                bl2 = true;
                continue;
            }
            if (bl2) {
                stringBuilder.append(replacement);
                bl2 = false;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean apply(Character character) {
        return this.matches(character.charValue());
    }

    static {
        CharMatcher charMatcher = CharMatcher.inRange('0', '9');
        String string = "\u0660\u06f0\u07c0\u0966\u09e6\u0a66\u0ae6\u0b66\u0be6\u0c66\u0ce6\u0d66\u0e50\u0ed0\u0f20\u1040\u1090\u17e0\u1810\u1946\u19d0\u1b50\u1bb0\u1c40\u1c50\ua620\ua8d0\ua900\uaa50\uff10";
        for (char c2 : string.toCharArray()) {
            charMatcher = charMatcher.or(CharMatcher.inRange(c2, (char)(c2 + 9)));
        }
        DIGIT = charMatcher.precomputed();
        JAVA_WHITESPACE = CharMatcher.inRange('\t', '\r').or(CharMatcher.inRange('\u001c', ' ')).or(CharMatcher.is('\u1680')).or(CharMatcher.is('\u180e')).or(CharMatcher.inRange('\u2000', '\u2006')).or(CharMatcher.inRange('\u2008', '\u200b')).or(CharMatcher.inRange('\u2028', '\u2029')).or(CharMatcher.is('\u205f')).or(CharMatcher.is('\u3000')).precomputed();
        JAVA_DIGIT = new CharMatcher(){

            @Override
            public boolean matches(char c2) {
                return Character.isDigit(c2);
            }
        };
        JAVA_LETTER = new CharMatcher(){

            @Override
            public boolean matches(char c2) {
                return Character.isLetter(c2);
            }
        };
        JAVA_LETTER_OR_DIGIT = new CharMatcher(){

            @Override
            public boolean matches(char c2) {
                return Character.isLetterOrDigit(c2);
            }
        };
        JAVA_UPPER_CASE = new CharMatcher(){

            @Override
            public boolean matches(char c2) {
                return Character.isUpperCase(c2);
            }
        };
        JAVA_LOWER_CASE = new CharMatcher(){

            @Override
            public boolean matches(char c2) {
                return Character.isLowerCase(c2);
            }
        };
        JAVA_ISO_CONTROL = CharMatcher.inRange('\u0000', '\u001f').or(CharMatcher.inRange('\u007f', '\u009f'));
        INVISIBLE = CharMatcher.inRange('\u0000', ' ').or(CharMatcher.inRange('\u007f', '\u00a0')).or(CharMatcher.is('\u00ad')).or(CharMatcher.inRange('\u0600', '\u0603')).or(CharMatcher.anyOf("\u06dd\u070f\u1680\u17b4\u17b5\u180e")).or(CharMatcher.inRange('\u2000', '\u200f')).or(CharMatcher.inRange('\u2028', '\u202f')).or(CharMatcher.inRange('\u205f', '\u2064')).or(CharMatcher.inRange('\u206a', '\u206f')).or(CharMatcher.is('\u3000')).or(CharMatcher.inRange('\ud800', '\uf8ff')).or(CharMatcher.anyOf("\ufeff\ufff9\ufffa\ufffb")).precomputed();
        SINGLE_WIDTH = CharMatcher.inRange('\u0000', '\u04f9').or(CharMatcher.is('\u05be')).or(CharMatcher.inRange('\u05d0', '\u05ea')).or(CharMatcher.is('\u05f3')).or(CharMatcher.is('\u05f4')).or(CharMatcher.inRange('\u0600', '\u06ff')).or(CharMatcher.inRange('\u0750', '\u077f')).or(CharMatcher.inRange('\u0e00', '\u0e7f')).or(CharMatcher.inRange('\u1e00', '\u20af')).or(CharMatcher.inRange('\u2100', '\u213a')).or(CharMatcher.inRange('\ufb50', '\ufdff')).or(CharMatcher.inRange('\ufe70', '\ufeff')).or(CharMatcher.inRange('\uff61', '\uffdc')).precomputed();
        ANY = new CharMatcher(){

            @Override
            public boolean matches(char c2) {
                return true;
            }

            @Override
            public int indexIn(CharSequence sequence) {
                return sequence.length() == 0 ? -1 : 0;
            }

            @Override
            public int indexIn(CharSequence sequence, int start) {
                int n2 = sequence.length();
                Preconditions.checkPositionIndex(start, n2);
                return start == n2 ? -1 : start;
            }

            @Override
            public int lastIndexIn(CharSequence sequence) {
                return sequence.length() - 1;
            }

            @Override
            public boolean matchesAllOf(CharSequence sequence) {
                Preconditions.checkNotNull(sequence);
                return true;
            }

            @Override
            public boolean matchesNoneOf(CharSequence sequence) {
                return sequence.length() == 0;
            }

            @Override
            public String removeFrom(CharSequence sequence) {
                Preconditions.checkNotNull(sequence);
                return "";
            }

            @Override
            public String replaceFrom(CharSequence sequence, char replacement) {
                char[] cArray = new char[sequence.length()];
                Arrays.fill(cArray, replacement);
                return new String(cArray);
            }

            @Override
            public String replaceFrom(CharSequence sequence, CharSequence replacement) {
                StringBuilder stringBuilder = new StringBuilder(sequence.length() * replacement.length());
                for (int i2 = 0; i2 < sequence.length(); ++i2) {
                    stringBuilder.append(replacement);
                }
                return stringBuilder.toString();
            }

            @Override
            public String collapseFrom(CharSequence sequence, char replacement) {
                return sequence.length() == 0 ? "" : String.valueOf(replacement);
            }

            @Override
            public String trimFrom(CharSequence sequence) {
                Preconditions.checkNotNull(sequence);
                return "";
            }

            @Override
            public int countIn(CharSequence sequence) {
                return sequence.length();
            }

            @Override
            public CharMatcher and(CharMatcher other) {
                return Preconditions.checkNotNull(other);
            }

            @Override
            public CharMatcher or(CharMatcher other) {
                Preconditions.checkNotNull(other);
                return this;
            }

            @Override
            public CharMatcher negate() {
                return NONE;
            }

            @Override
            public CharMatcher precomputed() {
                return this;
            }
        };
        NONE = new CharMatcher(){

            @Override
            public boolean matches(char c2) {
                return false;
            }

            @Override
            public int indexIn(CharSequence sequence) {
                Preconditions.checkNotNull(sequence);
                return -1;
            }

            @Override
            public int indexIn(CharSequence sequence, int start) {
                int n2 = sequence.length();
                Preconditions.checkPositionIndex(start, n2);
                return -1;
            }

            @Override
            public int lastIndexIn(CharSequence sequence) {
                Preconditions.checkNotNull(sequence);
                return -1;
            }

            @Override
            public boolean matchesAllOf(CharSequence sequence) {
                return sequence.length() == 0;
            }

            @Override
            public boolean matchesNoneOf(CharSequence sequence) {
                Preconditions.checkNotNull(sequence);
                return true;
            }

            @Override
            public String removeFrom(CharSequence sequence) {
                return ((Object)sequence).toString();
            }

            @Override
            public String replaceFrom(CharSequence sequence, char replacement) {
                return ((Object)sequence).toString();
            }

            @Override
            public String replaceFrom(CharSequence sequence, CharSequence replacement) {
                Preconditions.checkNotNull(replacement);
                return ((Object)sequence).toString();
            }

            @Override
            public String collapseFrom(CharSequence sequence, char replacement) {
                return ((Object)sequence).toString();
            }

            @Override
            public String trimFrom(CharSequence sequence) {
                return ((Object)sequence).toString();
            }

            @Override
            public int countIn(CharSequence sequence) {
                Preconditions.checkNotNull(sequence);
                return 0;
            }

            @Override
            public CharMatcher and(CharMatcher other) {
                Preconditions.checkNotNull(other);
                return this;
            }

            @Override
            public CharMatcher or(CharMatcher other) {
                return Preconditions.checkNotNull(other);
            }

            @Override
            public CharMatcher negate() {
                return ANY;
            }

            @Override
            void setBits(LookupTable table) {
            }

            @Override
            public CharMatcher precomputed() {
                return this;
            }
        };
    }

    private static final class LookupTable {
        int[] data = new int[2048];

        private LookupTable() {
        }

        void set(char index) {
            int n2 = index >> 5;
            this.data[n2] = this.data[n2] | '\u0001' << index;
        }

        boolean get(char index) {
            return (this.data[index >> 5] & '\u0001' << index) != 0;
        }
    }

    private static class Or
    extends CharMatcher {
        List<CharMatcher> components;

        Or(List<CharMatcher> components) {
            this.components = components;
        }

        @Override
        public boolean matches(char c2) {
            for (CharMatcher charMatcher : this.components) {
                if (!charMatcher.matches(c2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public CharMatcher or(CharMatcher other) {
            ArrayList<CharMatcher> arrayList = new ArrayList<CharMatcher>(this.components);
            arrayList.add(Preconditions.checkNotNull(other));
            return new Or(arrayList);
        }

        @Override
        void setBits(LookupTable table) {
            for (CharMatcher charMatcher : this.components) {
                charMatcher.setBits(table);
            }
        }
    }

    private static class And
    extends CharMatcher {
        List<CharMatcher> components;

        And(List<CharMatcher> components) {
            this.components = components;
        }

        @Override
        public boolean matches(char c2) {
            for (CharMatcher charMatcher : this.components) {
                if (charMatcher.matches(c2)) continue;
                return false;
            }
            return true;
        }

        @Override
        public CharMatcher and(CharMatcher other) {
            ArrayList<CharMatcher> arrayList = new ArrayList<CharMatcher>(this.components);
            arrayList.add(Preconditions.checkNotNull(other));
            return new And(arrayList);
        }
    }
}

