/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.collect;

import com.timevale.esign.paas.guava.common.annotations.GwtCompatible;
import com.timevale.esign.paas.guava.common.base.Preconditions;
import com.timevale.esign.paas.guava.common.collect.BstBalancePolicy;
import com.timevale.esign.paas.guava.common.collect.BstInOrderPath;
import com.timevale.esign.paas.guava.common.collect.BstModificationResult;
import com.timevale.esign.paas.guava.common.collect.BstModifier;
import com.timevale.esign.paas.guava.common.collect.BstMutationResult;
import com.timevale.esign.paas.guava.common.collect.BstMutationRule;
import com.timevale.esign.paas.guava.common.collect.BstNode;
import com.timevale.esign.paas.guava.common.collect.BstNodeFactory;
import com.timevale.esign.paas.guava.common.collect.BstSide;
import java.util.Comparator;
import javax.annotation.Nullable;

@GwtCompatible
final class BstOperations {
    private BstOperations() {
    }

    @Nullable
    public static <K, N extends BstNode<K, N>> N seek(Comparator<? super K> comparator, @Nullable N tree, K key) {
        Preconditions.checkNotNull(comparator);
        if (tree == null) {
            return null;
        }
        int n2 = comparator.compare(key, tree.getKey());
        if (n2 == 0) {
            return tree;
        }
        BstSide bstSide = n2 < 0 ? BstSide.LEFT : BstSide.RIGHT;
        return BstOperations.seek(comparator, tree.childOrNull(bstSide), key);
    }

    public static <K, N extends BstNode<K, N>> BstMutationResult<K, N> mutate(Comparator<? super K> comparator, BstMutationRule<K, N> mutationRule, @Nullable N tree, K key) {
        int n2;
        Preconditions.checkNotNull(comparator);
        Preconditions.checkNotNull(mutationRule);
        Preconditions.checkNotNull(key);
        if (tree != null && (n2 = comparator.compare(key, tree.getKey())) != 0) {
            BstSide bstSide = n2 < 0 ? BstSide.LEFT : BstSide.RIGHT;
            BstMutationResult<K, N> bstMutationResult = BstOperations.mutate(comparator, mutationRule, tree.childOrNull(bstSide), key);
            return bstMutationResult.lift(tree, bstSide, mutationRule.getNodeFactory(), mutationRule.getBalancePolicy());
        }
        return BstOperations.modify(tree, key, mutationRule);
    }

    public static <K, N extends BstNode<K, N>> BstMutationResult<K, N> mutate(BstInOrderPath<N> path, BstMutationRule<K, N> mutationRule) {
        Preconditions.checkNotNull(path);
        Preconditions.checkNotNull(mutationRule);
        BstBalancePolicy<N> bstBalancePolicy = mutationRule.getBalancePolicy();
        BstNodeFactory<N> bstNodeFactory = mutationRule.getNodeFactory();
        BstModifier<K, N> bstModifier = mutationRule.getModifier();
        Object n2 = path.getTip();
        K k2 = ((BstNode)n2).getKey();
        BstMutationResult bstMutationResult = BstOperations.modify(n2, k2, mutationRule);
        while (path.hasPrefix()) {
            BstInOrderPath bstInOrderPath = (BstInOrderPath)path.getPrefix();
            bstMutationResult = bstMutationResult.lift(bstInOrderPath.getTip(), path.getSideOfExtension(), bstNodeFactory, bstBalancePolicy);
            path = bstInOrderPath;
        }
        return bstMutationResult;
    }

    private static <K, N extends BstNode<K, N>> BstMutationResult<K, N> modify(@Nullable N tree, K key, BstMutationRule<K, N> mutationRule) {
        N n2;
        BstBalancePolicy<Object> bstBalancePolicy = mutationRule.getBalancePolicy();
        BstNodeFactory<Object> bstNodeFactory = mutationRule.getNodeFactory();
        BstModifier<K, Object> bstModifier = mutationRule.getModifier();
        N n3 = tree;
        Object n4 = tree == null ? null : (Object)bstNodeFactory.createLeaf(tree);
        BstModificationResult<Object> bstModificationResult = bstModifier.modify(key, n4);
        Object n5 = null;
        Object n6 = null;
        if (tree != null) {
            n5 = tree.childOrNull(BstSide.LEFT);
            n6 = tree.childOrNull(BstSide.RIGHT);
        }
        switch (bstModificationResult.getType()) {
            case IDENTITY: {
                n2 = tree;
                break;
            }
            case REBUILDING_CHANGE: {
                if (bstModificationResult.getChangedTarget() != null) {
                    n2 = bstNodeFactory.createNode(bstModificationResult.getChangedTarget(), n5, n6);
                    break;
                }
                if (tree == null) {
                    n2 = null;
                    break;
                }
                throw new AssertionError((Object)"Modification result is a REBUILDING_CHANGE, but rebalancing required");
            }
            case REBALANCING_CHANGE: {
                if (bstModificationResult.getChangedTarget() != null) {
                    n2 = bstBalancePolicy.balance(bstNodeFactory, bstModificationResult.getChangedTarget(), n5, n6);
                    break;
                }
                if (tree != null) {
                    n2 = bstBalancePolicy.combine(bstNodeFactory, n5, n6);
                    break;
                }
                n2 = null;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return BstMutationResult.mutationResult(key, n3, n2, bstModificationResult);
    }

    public static <K, N extends BstNode<K, N>> BstMutationResult<K, N> extractMin(N root, BstNodeFactory<N> nodeFactory, BstBalancePolicy<N> balancePolicy) {
        Preconditions.checkNotNull(root);
        Preconditions.checkNotNull(nodeFactory);
        Preconditions.checkNotNull(balancePolicy);
        if (root.hasChild(BstSide.LEFT)) {
            BstMutationResult<K, N> bstMutationResult = BstOperations.extractMin(root.getChild(BstSide.LEFT), nodeFactory, balancePolicy);
            return bstMutationResult.lift(root, BstSide.LEFT, nodeFactory, balancePolicy);
        }
        return BstMutationResult.mutationResult(root.getKey(), root, root.childOrNull(BstSide.RIGHT), BstModificationResult.rebalancingChange(root, null));
    }

    public static <K, N extends BstNode<K, N>> BstMutationResult<K, N> extractMax(N root, BstNodeFactory<N> nodeFactory, BstBalancePolicy<N> balancePolicy) {
        Preconditions.checkNotNull(root);
        Preconditions.checkNotNull(nodeFactory);
        Preconditions.checkNotNull(balancePolicy);
        if (root.hasChild(BstSide.RIGHT)) {
            BstMutationResult<K, N> bstMutationResult = BstOperations.extractMax(root.getChild(BstSide.RIGHT), nodeFactory, balancePolicy);
            return bstMutationResult.lift(root, BstSide.RIGHT, nodeFactory, balancePolicy);
        }
        return BstMutationResult.mutationResult(root.getKey(), root, root.childOrNull(BstSide.LEFT), BstModificationResult.rebalancingChange(root, null));
    }

    public static <N extends BstNode<?, N>> N insertMin(@Nullable N root, N entry, BstNodeFactory<N> nodeFactory, BstBalancePolicy<N> balancePolicy) {
        Preconditions.checkNotNull(entry);
        Preconditions.checkNotNull(nodeFactory);
        Preconditions.checkNotNull(balancePolicy);
        if (root == null) {
            return nodeFactory.createLeaf(entry);
        }
        return balancePolicy.balance(nodeFactory, root, BstOperations.insertMin(root.childOrNull(BstSide.LEFT), entry, nodeFactory, balancePolicy), root.childOrNull(BstSide.RIGHT));
    }

    public static <N extends BstNode<?, N>> N insertMax(@Nullable N root, N entry, BstNodeFactory<N> nodeFactory, BstBalancePolicy<N> balancePolicy) {
        Preconditions.checkNotNull(entry);
        Preconditions.checkNotNull(nodeFactory);
        Preconditions.checkNotNull(balancePolicy);
        if (root == null) {
            return nodeFactory.createLeaf(entry);
        }
        return balancePolicy.balance(nodeFactory, root, root.childOrNull(BstSide.LEFT), BstOperations.insertMax(root.childOrNull(BstSide.RIGHT), entry, nodeFactory, balancePolicy));
    }
}

