/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.collect;

import com.timevale.esign.paas.guava.common.annotations.Beta;
import com.timevale.esign.paas.guava.common.annotations.VisibleForTesting;
import com.timevale.esign.paas.guava.common.base.Preconditions;
import com.timevale.esign.paas.guava.common.collect.AbstractIterator;
import com.timevale.esign.paas.guava.common.collect.AbstractMultiset;
import com.timevale.esign.paas.guava.common.collect.ForwardingIterator;
import com.timevale.esign.paas.guava.common.collect.ForwardingSet;
import com.timevale.esign.paas.guava.common.collect.GenericMapMaker;
import com.timevale.esign.paas.guava.common.collect.Iterables;
import com.timevale.esign.paas.guava.common.collect.Iterators;
import com.timevale.esign.paas.guava.common.collect.Lists;
import com.timevale.esign.paas.guava.common.collect.Multiset;
import com.timevale.esign.paas.guava.common.collect.Multisets;
import com.timevale.esign.paas.guava.common.collect.Serialization;
import com.timevale.esign.paas.guava.common.primitives.Ints;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

public final class ConcurrentHashMultiset<E>
extends AbstractMultiset<E>
implements Serializable {
    private final transient ConcurrentMap<E, AtomicInteger> countMap;
    private transient EntrySet entrySet;
    private static final long serialVersionUID = 1L;

    public static <E> ConcurrentHashMultiset<E> create() {
        return new ConcurrentHashMultiset(new ConcurrentHashMap());
    }

    public static <E> ConcurrentHashMultiset<E> create(Iterable<? extends E> elements) {
        ConcurrentHashMultiset<E> concurrentHashMultiset = ConcurrentHashMultiset.create();
        Iterables.addAll(concurrentHashMultiset, elements);
        return concurrentHashMultiset;
    }

    @Beta
    public static <E> ConcurrentHashMultiset<E> create(GenericMapMaker<? super E, ? super Number> mapMaker) {
        return new ConcurrentHashMultiset(mapMaker.makeMap());
    }

    @VisibleForTesting
    ConcurrentHashMultiset(ConcurrentMap<E, AtomicInteger> countMap) {
        Preconditions.checkArgument(countMap.isEmpty());
        this.countMap = countMap;
    }

    @Override
    public int count(@Nullable Object element) {
        AtomicInteger atomicInteger = this.safeGet(element);
        return atomicInteger == null ? 0 : atomicInteger.get();
    }

    private AtomicInteger safeGet(Object element) {
        try {
            return (AtomicInteger)this.countMap.get(element);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    @Override
    public int size() {
        long l2 = 0L;
        for (AtomicInteger atomicInteger : this.countMap.values()) {
            l2 += (long)atomicInteger.get();
        }
        return Ints.saturatedCast(l2);
    }

    @Override
    public Object[] toArray() {
        return this.snapshot().toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.snapshot().toArray(array);
    }

    private List<E> snapshot() {
        ArrayList<E> arrayList = Lists.newArrayListWithExpectedSize(this.size());
        for (Multiset.Entry<E> entry : this.entrySet()) {
            E e2 = entry.getElement();
            for (int i2 = entry.getCount(); i2 > 0; --i2) {
                arrayList.add(e2);
            }
        }
        return arrayList;
    }

    @Override
    public int add(E element, int occurrences) {
        AtomicInteger atomicInteger;
        AtomicInteger atomicInteger2;
        if (occurrences == 0) {
            return this.count(element);
        }
        Preconditions.checkArgument(occurrences > 0, "Invalid occurrences: %s", occurrences);
        do {
            int n2;
            if ((atomicInteger = this.safeGet(element)) == null && (atomicInteger = this.countMap.putIfAbsent(element, new AtomicInteger(occurrences))) == null) {
                return 0;
            }
            while ((n2 = atomicInteger.get()) != 0) {
                Preconditions.checkArgument(occurrences <= Integer.MAX_VALUE - n2, "Overflow adding %s occurrences to a count of %s", occurrences, n2);
                int n3 = n2 + occurrences;
                if (!atomicInteger.compareAndSet(n2, n3)) continue;
                return n2;
            }
        } while (this.countMap.putIfAbsent(element, atomicInteger2 = new AtomicInteger(occurrences)) != null && !this.countMap.replace(element, atomicInteger, atomicInteger2));
        return 0;
    }

    @Override
    public int remove(@Nullable Object element, int occurrences) {
        int n2;
        if (occurrences == 0) {
            return this.count(element);
        }
        Preconditions.checkArgument(occurrences > 0, "Invalid occurrences: %s", occurrences);
        AtomicInteger atomicInteger = this.safeGet(element);
        if (atomicInteger == null) {
            return 0;
        }
        while ((n2 = atomicInteger.get()) != 0) {
            int n3 = Math.max(0, n2 - occurrences);
            if (!atomicInteger.compareAndSet(n2, n3)) continue;
            if (n3 == 0) {
                this.countMap.remove(element, atomicInteger);
            }
            return n2;
        }
        return 0;
    }

    public boolean removeExactly(@Nullable Object element, int occurrences) {
        int n2;
        int n3;
        if (occurrences == 0) {
            return true;
        }
        Preconditions.checkArgument(occurrences > 0, "Invalid occurrences: %s", occurrences);
        AtomicInteger atomicInteger = this.safeGet(element);
        if (atomicInteger == null) {
            return false;
        }
        do {
            if ((n3 = atomicInteger.get()) >= occurrences) continue;
            return false;
        } while (!atomicInteger.compareAndSet(n3, n2 = n3 - occurrences));
        if (n2 == 0) {
            this.countMap.remove(element, atomicInteger);
        }
        return true;
    }

    @Override
    public int setCount(E element, int count) {
        int n2;
        AtomicInteger atomicInteger;
        Multisets.checkNonnegative(count, "count");
        block0: while (true) {
            if ((atomicInteger = this.safeGet(element)) == null) {
                if (count == 0) {
                    return 0;
                }
                atomicInteger = this.countMap.putIfAbsent(element, new AtomicInteger(count));
                if (atomicInteger == null) {
                    return 0;
                }
            }
            do {
                if ((n2 = atomicInteger.get()) != 0) continue;
                if (count == 0) {
                    return 0;
                }
                AtomicInteger atomicInteger2 = new AtomicInteger(count);
                if (this.countMap.putIfAbsent(element, atomicInteger2) != null && !this.countMap.replace(element, atomicInteger, atomicInteger2)) continue block0;
                return 0;
            } while (!atomicInteger.compareAndSet(n2, count));
            break;
        }
        if (count == 0) {
            this.countMap.remove(element, atomicInteger);
        }
        return n2;
    }

    @Override
    public boolean setCount(E element, int expectedOldCount, int newCount) {
        Multisets.checkNonnegative(expectedOldCount, "oldCount");
        Multisets.checkNonnegative(newCount, "newCount");
        AtomicInteger atomicInteger = this.safeGet(element);
        if (atomicInteger == null) {
            if (expectedOldCount != 0) {
                return false;
            }
            if (newCount == 0) {
                return true;
            }
            return this.countMap.putIfAbsent(element, new AtomicInteger(newCount)) == null;
        }
        int n2 = atomicInteger.get();
        if (n2 == expectedOldCount) {
            if (n2 == 0) {
                if (newCount == 0) {
                    this.countMap.remove(element, atomicInteger);
                    return true;
                }
                AtomicInteger atomicInteger2 = new AtomicInteger(newCount);
                return this.countMap.putIfAbsent(element, atomicInteger2) == null || this.countMap.replace(element, atomicInteger, atomicInteger2);
            }
            if (atomicInteger.compareAndSet(n2, newCount)) {
                if (newCount == 0) {
                    this.countMap.remove(element, atomicInteger);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    Set<E> createElementSet() {
        final Set set = this.countMap.keySet();
        return new ForwardingSet<E>(){

            @Override
            protected Set<E> delegate() {
                return set;
            }

            @Override
            public boolean remove(Object object) {
                try {
                    return set.remove(object);
                }
                catch (NullPointerException nullPointerException) {
                    return false;
                }
                catch (ClassCastException classCastException) {
                    return false;
                }
            }
        };
    }

    @Override
    public Set<Multiset.Entry<E>> entrySet() {
        EntrySet entrySet = this.entrySet;
        if (entrySet == null) {
            this.entrySet = entrySet = new EntrySet();
        }
        return entrySet;
    }

    @Override
    int distinctElements() {
        return this.countMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.countMap.isEmpty();
    }

    @Override
    Iterator<Multiset.Entry<E>> entryIterator() {
        final AbstractIterator abstractIterator = new AbstractIterator<Multiset.Entry<E>>(){
            private Iterator<Map.Entry<E, AtomicInteger>> mapEntries;
            {
                this.mapEntries = ConcurrentHashMultiset.this.countMap.entrySet().iterator();
            }

            @Override
            protected Multiset.Entry<E> computeNext() {
                Map.Entry entry;
                int n2;
                do {
                    if (this.mapEntries.hasNext()) continue;
                    return (Multiset.Entry)this.endOfData();
                } while ((n2 = (entry = this.mapEntries.next()).getValue().get()) == 0);
                return Multisets.immutableEntry(entry.getKey(), n2);
            }
        };
        return new ForwardingIterator<Multiset.Entry<E>>(){
            private Multiset.Entry<E> last;

            @Override
            protected Iterator<Multiset.Entry<E>> delegate() {
                return abstractIterator;
            }

            @Override
            public Multiset.Entry<E> next() {
                this.last = (Multiset.Entry)super.next();
                return this.last;
            }

            @Override
            public void remove() {
                Preconditions.checkState(this.last != null);
                ConcurrentHashMultiset.this.setCount(this.last.getElement(), 0);
                this.last = null;
            }
        };
    }

    @Override
    public void clear() {
        this.countMap.clear();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeObject(this.countMap);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        ConcurrentMap concurrentMap = (ConcurrentMap)stream.readObject();
        FieldSettersHolder.COUNT_MAP_FIELD_SETTER.set(this, concurrentMap);
    }

    private class EntrySet
    extends AbstractMultiset.EntrySet {
        private EntrySet() {
        }

        @Override
        ConcurrentHashMultiset<E> multiset() {
            return ConcurrentHashMultiset.this;
        }

        @Override
        public Object[] toArray() {
            return this.snapshot().toArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return this.snapshot().toArray(array);
        }

        private List<Multiset.Entry<E>> snapshot() {
            ArrayList arrayList = Lists.newArrayListWithExpectedSize(this.size());
            Iterators.addAll(arrayList, this.iterator());
            return arrayList;
        }

        @Override
        public boolean remove(Object object) {
            if (object instanceof Multiset.Entry) {
                Multiset.Entry entry = (Multiset.Entry)object;
                Object e2 = entry.getElement();
                int n2 = entry.getCount();
                if (n2 != 0) {
                    Multiset multiset = this.multiset();
                    return multiset.setCount(e2, n2, 0);
                }
            }
            return false;
        }
    }

    private static class FieldSettersHolder {
        static final Serialization.FieldSetter<ConcurrentHashMultiset> COUNT_MAP_FIELD_SETTER = Serialization.getFieldSetter(ConcurrentHashMultiset.class, "countMap");

        private FieldSettersHolder() {
        }
    }
}

