/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.collect;

import com.timevale.esign.paas.guava.common.annotations.GwtCompatible;
import com.timevale.esign.paas.guava.common.base.Objects;
import com.timevale.esign.paas.guava.common.base.Optional;
import com.timevale.esign.paas.guava.common.base.Preconditions;
import com.timevale.esign.paas.guava.common.collect.BoundType;
import com.timevale.esign.paas.guava.common.collect.Ordering;
import com.timevale.esign.paas.guava.common.collect.Range;
import java.io.Serializable;
import java.util.Comparator;
import javax.annotation.Nullable;

@GwtCompatible(serializable=true)
final class GeneralRange<T>
implements Serializable {
    private final Comparator<? super T> comparator;
    private final Optional<T> lowerEndpoint;
    private final BoundType lowerBoundType;
    private final Optional<T> upperEndpoint;
    private final BoundType upperBoundType;
    private transient GeneralRange<T> reverse;

    static <T extends Comparable> GeneralRange<T> from(Range<T> range) {
        Optional optional = range.hasLowerBound() ? Optional.of(range.lowerEndpoint()) : Optional.absent();
        BoundType boundType = range.hasLowerBound() ? range.lowerBoundType() : BoundType.OPEN;
        Optional optional2 = range.hasUpperBound() ? Optional.of(range.upperEndpoint()) : Optional.absent();
        BoundType boundType2 = range.hasUpperBound() ? range.upperBoundType() : BoundType.OPEN;
        return new GeneralRange(Ordering.natural(), optional, boundType, optional2, boundType2);
    }

    static <T> GeneralRange<T> all(Comparator<? super T> comparator) {
        return new GeneralRange<T>(comparator, Optional.absent(), BoundType.OPEN, Optional.absent(), BoundType.OPEN);
    }

    static <T> GeneralRange<T> downTo(Comparator<? super T> comparator, T endpoint, BoundType boundType) {
        return new GeneralRange<T>(comparator, Optional.of(endpoint), boundType, Optional.absent(), BoundType.OPEN);
    }

    static <T> GeneralRange<T> upTo(Comparator<? super T> comparator, T endpoint, BoundType boundType) {
        return new GeneralRange<T>(comparator, Optional.absent(), BoundType.OPEN, Optional.of(endpoint), boundType);
    }

    static <T> GeneralRange<T> range(Comparator<? super T> comparator, T lower, BoundType lowerType, T upper, BoundType upperType) {
        return new GeneralRange<T>(comparator, Optional.of(lower), lowerType, Optional.of(upper), upperType);
    }

    private GeneralRange(Comparator<? super T> comparator, Optional<T> lowerEndpoint, BoundType lowerBoundType, Optional<T> upperEndpoint, BoundType upperBoundType) {
        this.comparator = Preconditions.checkNotNull(comparator);
        this.lowerEndpoint = Preconditions.checkNotNull(lowerEndpoint);
        this.lowerBoundType = Preconditions.checkNotNull(lowerBoundType);
        this.upperEndpoint = Preconditions.checkNotNull(upperEndpoint);
        this.upperBoundType = Preconditions.checkNotNull(upperBoundType);
        if (lowerEndpoint.isPresent() && upperEndpoint.isPresent()) {
            int n2 = comparator.compare(lowerEndpoint.get(), upperEndpoint.get());
            Preconditions.checkArgument(n2 <= 0, "lowerEndpoint (%s) > upperEndpoint (%s)", lowerEndpoint, upperEndpoint);
            if (n2 == 0) {
                Preconditions.checkArgument(lowerBoundType != BoundType.OPEN | upperBoundType != BoundType.OPEN);
            }
        }
    }

    Comparator<? super T> comparator() {
        return this.comparator;
    }

    boolean hasLowerBound() {
        return this.lowerEndpoint.isPresent();
    }

    boolean hasUpperBound() {
        return this.upperEndpoint.isPresent();
    }

    boolean isEmpty() {
        return this.hasUpperBound() && this.tooLow(this.upperEndpoint.get()) || this.hasLowerBound() && this.tooHigh(this.lowerEndpoint.get());
    }

    boolean tooLow(T t2) {
        if (!this.hasLowerBound()) {
            return false;
        }
        T t3 = this.lowerEndpoint.get();
        int n2 = this.comparator.compare(t2, t3);
        return n2 < 0 | n2 == 0 & this.lowerBoundType == BoundType.OPEN;
    }

    boolean tooHigh(T t2) {
        if (!this.hasUpperBound()) {
            return false;
        }
        T t3 = this.upperEndpoint.get();
        int n2 = this.comparator.compare(t2, t3);
        return n2 > 0 | n2 == 0 & this.upperBoundType == BoundType.OPEN;
    }

    boolean contains(T t2) {
        Preconditions.checkNotNull(t2);
        return !this.tooLow(t2) && !this.tooHigh(t2);
    }

    GeneralRange<T> intersect(GeneralRange<T> other) {
        int n2;
        int n3;
        Preconditions.checkNotNull(other);
        Preconditions.checkArgument(((Object)this.comparator).equals(other.comparator));
        Optional<T> optional = this.lowerEndpoint;
        BoundType boundType = this.lowerBoundType;
        if (!this.hasLowerBound()) {
            optional = other.lowerEndpoint;
            boundType = other.lowerBoundType;
        } else if (other.hasLowerBound() && ((n3 = this.comparator.compare(this.lowerEndpoint.get(), other.lowerEndpoint.get())) < 0 || n3 == 0 && other.lowerBoundType == BoundType.OPEN)) {
            optional = other.lowerEndpoint;
            boundType = other.lowerBoundType;
        }
        Optional<T> optional2 = this.upperEndpoint;
        BoundType boundType2 = this.upperBoundType;
        if (!this.hasUpperBound()) {
            optional2 = other.upperEndpoint;
            boundType2 = other.upperBoundType;
        } else if (other.hasUpperBound() && ((n2 = this.comparator.compare(this.upperEndpoint.get(), other.upperEndpoint.get())) > 0 || n2 == 0 && other.upperBoundType == BoundType.OPEN)) {
            optional2 = other.upperEndpoint;
            boundType2 = other.upperBoundType;
        }
        if (optional.isPresent() && optional2.isPresent() && ((n2 = this.comparator.compare(optional.get(), optional2.get())) > 0 || n2 == 0 && boundType == BoundType.OPEN && boundType2 == BoundType.OPEN)) {
            optional = optional2;
            boundType = BoundType.OPEN;
            boundType2 = BoundType.CLOSED;
        }
        return new GeneralRange<T>(this.comparator, optional, boundType, optional2, boundType2);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof GeneralRange) {
            GeneralRange generalRange = (GeneralRange)obj;
            return ((Object)this.comparator).equals(generalRange.comparator) && this.lowerEndpoint.equals(generalRange.lowerEndpoint) && this.lowerBoundType.equals((Object)generalRange.lowerBoundType) && this.upperEndpoint.equals(generalRange.upperEndpoint) && this.upperBoundType.equals((Object)generalRange.upperBoundType);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.comparator, this.lowerEndpoint, this.lowerBoundType, this.upperEndpoint, this.upperBoundType});
    }

    public GeneralRange<T> reverse() {
        GeneralRange<Object> generalRange = this.reverse;
        if (generalRange == null) {
            generalRange = new GeneralRange(Ordering.from(this.comparator).reverse(), this.upperEndpoint, this.upperBoundType, this.lowerEndpoint, this.lowerBoundType);
            generalRange.reverse = this;
            this.reverse = generalRange;
            return this.reverse;
        }
        return generalRange;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.comparator).append(":");
        switch (this.lowerBoundType) {
            case CLOSED: {
                stringBuilder.append('[');
                break;
            }
            case OPEN: {
                stringBuilder.append('(');
            }
        }
        if (this.hasLowerBound()) {
            stringBuilder.append(this.lowerEndpoint.get());
        } else {
            stringBuilder.append("-\u221e");
        }
        stringBuilder.append(',');
        if (this.hasUpperBound()) {
            stringBuilder.append(this.upperEndpoint.get());
        } else {
            stringBuilder.append("\u221e");
        }
        switch (this.upperBoundType) {
            case CLOSED: {
                stringBuilder.append(']');
                break;
            }
            case OPEN: {
                stringBuilder.append(')');
            }
        }
        return stringBuilder.toString();
    }
}

