/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.collect;

import com.timevale.esign.paas.guava.common.annotations.GwtCompatible;
import com.timevale.esign.paas.guava.common.base.Preconditions;
import com.timevale.esign.paas.guava.common.collect.AbstractIndexedListIterator;
import com.timevale.esign.paas.guava.common.collect.Collections2;
import com.timevale.esign.paas.guava.common.collect.EmptyImmutableSet;
import com.timevale.esign.paas.guava.common.collect.Hashing;
import com.timevale.esign.paas.guava.common.collect.ImmutableAsList;
import com.timevale.esign.paas.guava.common.collect.ImmutableCollection;
import com.timevale.esign.paas.guava.common.collect.ImmutableList;
import com.timevale.esign.paas.guava.common.collect.ImmutableSortedSet;
import com.timevale.esign.paas.guava.common.collect.Iterators;
import com.timevale.esign.paas.guava.common.collect.Lists;
import com.timevale.esign.paas.guava.common.collect.ObjectArrays;
import com.timevale.esign.paas.guava.common.collect.RegularImmutableSet;
import com.timevale.esign.paas.guava.common.collect.Sets;
import com.timevale.esign.paas.guava.common.collect.SingletonImmutableSet;
import com.timevale.esign.paas.guava.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;

@GwtCompatible(serializable=true, emulated=true)
public abstract class ImmutableSet<E>
extends ImmutableCollection<E>
implements Set<E> {
    static final int MAX_TABLE_SIZE = 0x40000000;
    static final int CUTOFF = 0x20000000;

    public static <E> ImmutableSet<E> of() {
        return EmptyImmutableSet.INSTANCE;
    }

    public static <E> ImmutableSet<E> of(E element) {
        return new SingletonImmutableSet<E>(element);
    }

    public static <E> ImmutableSet<E> of(E e1, E e2) {
        return ImmutableSet.construct(e1, e2);
    }

    public static <E> ImmutableSet<E> of(E e1, E e2, E e3) {
        return ImmutableSet.construct(e1, e2, e3);
    }

    public static <E> ImmutableSet<E> of(E e1, E e2, E e3, E e4) {
        return ImmutableSet.construct(e1, e2, e3, e4);
    }

    public static <E> ImmutableSet<E> of(E e1, E e2, E e3, E e4, E e5) {
        return ImmutableSet.construct(e1, e2, e3, e4, e5);
    }

    public static <E> ImmutableSet<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E ... others) {
        int n2 = 6;
        Object[] objectArray = new Object[6 + others.length];
        objectArray[0] = e1;
        objectArray[1] = e2;
        objectArray[2] = e3;
        objectArray[3] = e4;
        objectArray[4] = e5;
        objectArray[5] = e6;
        for (int i2 = 6; i2 < objectArray.length; ++i2) {
            objectArray[i2] = others[i2 - 6];
        }
        return ImmutableSet.construct(objectArray);
    }

    private static <E> ImmutableSet<E> construct(Object ... elements) {
        Object[] objectArray;
        Object object;
        int n2 = ImmutableSet.chooseTableSize(elements.length);
        Object[] objectArray2 = new Object[n2];
        int n3 = n2 - 1;
        ArrayList<Object> arrayList = null;
        int n4 = 0;
        block0: for (int i2 = 0; i2 < elements.length; ++i2) {
            object = elements[i2];
            int n5 = object.hashCode();
            int n6 = Hashing.smear(n5);
            while (true) {
                int n7;
                Object object2;
                if ((object2 = objectArray2[n7 = n6 & n3]) == null) {
                    if (arrayList != null) {
                        arrayList.add(object);
                    }
                    objectArray2[n7] = object;
                    n4 += n5;
                    continue block0;
                }
                if (object2.equals(object)) {
                    if (arrayList != null) continue block0;
                    arrayList = new ArrayList<Object>(elements.length);
                    for (int i3 = 0; i3 < i2; ++i3) {
                        Object object3 = elements[i3];
                        arrayList.add(object3);
                    }
                    continue block0;
                }
                ++n6;
            }
        }
        Object[] objectArray3 = objectArray = arrayList == null ? elements : arrayList.toArray();
        if (objectArray.length == 1) {
            object = objectArray[0];
            return new SingletonImmutableSet<Object>(object, n4);
        }
        if (n2 > 2 * ImmutableSet.chooseTableSize(objectArray.length)) {
            return ImmutableSet.construct(objectArray);
        }
        return new RegularImmutableSet(objectArray, n4, objectArray2, n3);
    }

    static int chooseTableSize(int setSize) {
        if (setSize < 0x20000000) {
            return Integer.highestOneBit(setSize) << 2;
        }
        Preconditions.checkArgument(setSize < 0x40000000, "collection too large");
        return 0x40000000;
    }

    @Deprecated
    public static <E> ImmutableSet<E> of(E[] elements) {
        return ImmutableSet.copyOf(elements);
    }

    public static <E> ImmutableSet<E> copyOf(E[] elements) {
        switch (elements.length) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                return ImmutableSet.of(elements[0]);
            }
        }
        return ImmutableSet.construct((Object[])elements.clone());
    }

    public static <E> ImmutableSet<E> copyOf(Iterable<? extends E> elements) {
        return elements instanceof Collection ? ImmutableSet.copyOf(Collections2.cast(elements)) : ImmutableSet.copyOf(elements.iterator());
    }

    public static <E> ImmutableSet<E> copyOf(Iterator<? extends E> elements) {
        return ImmutableSet.copyFromCollection(Lists.newArrayList(elements));
    }

    public static <E> ImmutableSet<E> copyOf(Collection<? extends E> elements) {
        ImmutableSet immutableSet;
        if (elements instanceof ImmutableSet && !(elements instanceof ImmutableSortedSet) && !(immutableSet = (ImmutableSet)elements).isPartialView()) {
            return immutableSet;
        }
        return ImmutableSet.copyFromCollection(elements);
    }

    private static <E> ImmutableSet<E> copyFromCollection(Collection<? extends E> collection) {
        Object[] objectArray = collection.toArray();
        switch (objectArray.length) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                Object object = objectArray[0];
                return ImmutableSet.of(object);
            }
        }
        return ImmutableSet.construct(objectArray);
    }

    ImmutableSet() {
    }

    boolean isHashCodeFast() {
        return false;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ImmutableSet && this.isHashCodeFast() && ((ImmutableSet)object).isHashCodeFast() && this.hashCode() != object.hashCode()) {
            return false;
        }
        return Sets.equalsImpl(this, object);
    }

    @Override
    public int hashCode() {
        return Sets.hashCodeImpl(this);
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    @Override
    Object writeReplace() {
        return new SerializedForm(this.toArray());
    }

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    public static class Builder<E>
    extends ImmutableCollection.Builder<E> {
        final ArrayList<E> contents = Lists.newArrayList();

        @Override
        public Builder<E> add(E element) {
            this.contents.add(Preconditions.checkNotNull(element));
            return this;
        }

        @Override
        public Builder<E> add(E ... elements) {
            this.contents.ensureCapacity(this.contents.size() + elements.length);
            super.add(elements);
            return this;
        }

        @Override
        public Builder<E> addAll(Iterable<? extends E> elements) {
            if (elements instanceof Collection) {
                Collection collection = (Collection)elements;
                this.contents.ensureCapacity(this.contents.size() + collection.size());
            }
            super.addAll(elements);
            return this;
        }

        @Override
        public Builder<E> addAll(Iterator<? extends E> elements) {
            super.addAll(elements);
            return this;
        }

        @Override
        public ImmutableSet<E> build() {
            return ImmutableSet.copyOf(this.contents);
        }
    }

    private static class SerializedForm
    implements Serializable {
        final Object[] elements;
        private static final long serialVersionUID = 0L;

        SerializedForm(Object[] elements) {
            this.elements = elements;
        }

        Object readResolve() {
            return ImmutableSet.copyOf(this.elements);
        }
    }

    static abstract class TransformedImmutableSet<D, E>
    extends ImmutableSet<E> {
        final D[] source;
        final int hashCode;

        TransformedImmutableSet(D[] source, int hashCode) {
            this.source = source;
            this.hashCode = hashCode;
        }

        abstract E transform(D var1);

        @Override
        public int size() {
            return this.source.length;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public UnmodifiableIterator<E> iterator() {
            return new AbstractIndexedListIterator<E>(this.source.length){

                @Override
                protected E get(int index) {
                    return this.transform(source[index]);
                }
            };
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[this.size()]);
        }

        @Override
        public <T> T[] toArray(T[] array) {
            int n2 = this.size();
            if (array.length < n2) {
                array = ObjectArrays.newArray(array, n2);
            } else if (array.length > n2) {
                array[n2] = null;
            }
            T[] TArray = array;
            for (int i2 = 0; i2 < this.source.length; ++i2) {
                TArray[i2] = this.transform(this.source[i2]);
            }
            return array;
        }

        @Override
        public final int hashCode() {
            return this.hashCode;
        }

        @Override
        boolean isHashCodeFast() {
            return true;
        }
    }

    static abstract class ArrayImmutableSet<E>
    extends ImmutableSet<E> {
        final transient Object[] elements;

        ArrayImmutableSet(Object[] elements) {
            this.elements = elements;
        }

        @Override
        public int size() {
            return this.elements.length;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public UnmodifiableIterator<E> iterator() {
            return Iterators.forArray(this.elements);
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.size()];
            System.arraycopy(this.elements, 0, objectArray, 0, this.size());
            return objectArray;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            int n2 = this.size();
            if (array.length < n2) {
                array = ObjectArrays.newArray(array, n2);
            } else if (array.length > n2) {
                array[n2] = null;
            }
            System.arraycopy(this.elements, 0, array, 0, n2);
            return array;
        }

        @Override
        public boolean containsAll(Collection<?> targets) {
            if (targets == this) {
                return true;
            }
            if (!(targets instanceof ArrayImmutableSet)) {
                return super.containsAll(targets);
            }
            if (targets.size() > this.size()) {
                return false;
            }
            for (Object object : ((ArrayImmutableSet)targets).elements) {
                if (this.contains(object)) continue;
                return false;
            }
            return true;
        }

        @Override
        boolean isPartialView() {
            return false;
        }

        @Override
        ImmutableList<E> createAsList() {
            return new ImmutableAsList(this.elements, this);
        }
    }
}

