/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.collect;

import com.timevale.esign.paas.guava.common.annotations.GwtCompatible;
import com.timevale.esign.paas.guava.common.base.Preconditions;
import com.timevale.esign.paas.guava.common.collect.AbstractIndexedListIterator;
import com.timevale.esign.paas.guava.common.collect.Collections2;
import com.timevale.esign.paas.guava.common.collect.Hashing;
import com.timevale.esign.paas.guava.common.collect.ImmutableCollection;
import com.timevale.esign.paas.guava.common.collect.ImmutableEntry;
import com.timevale.esign.paas.guava.common.collect.ImmutableMap;
import com.timevale.esign.paas.guava.common.collect.ImmutableSet;
import com.timevale.esign.paas.guava.common.collect.UnmodifiableIterator;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@GwtCompatible(serializable=true, emulated=true)
final class RegularImmutableMap<K, V>
extends ImmutableMap<K, V> {
    private final transient LinkedEntry<K, V>[] entries;
    private final transient LinkedEntry<K, V>[] table;
    private final transient int mask;
    private final transient int keySetHashCode;
    private transient ImmutableSet<Map.Entry<K, V>> entrySet;
    private transient ImmutableSet<K> keySet;
    private transient ImmutableCollection<V> values;
    private static final long serialVersionUID = 0L;

    RegularImmutableMap(Map.Entry<?, ?> ... immutableEntries) {
        int n2 = immutableEntries.length;
        this.entries = this.createEntryArray(n2);
        int n3 = RegularImmutableMap.chooseTableSize(n2);
        this.table = this.createEntryArray(n3);
        this.mask = n3 - 1;
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            LinkedEntry<K, V> linkedEntry;
            Map.Entry<?, ?> entry = immutableEntries[i2];
            Object obj = entry.getKey();
            int n5 = obj.hashCode();
            n4 += n5;
            int n6 = Hashing.smear(n5) & this.mask;
            LinkedEntry<?, ?> linkedEntry2 = RegularImmutableMap.newLinkedEntry(obj, entry.getValue(), linkedEntry);
            this.table[n6] = linkedEntry2;
            this.entries[i2] = linkedEntry2;
            for (linkedEntry = this.table[n6]; linkedEntry != null; linkedEntry = linkedEntry.next()) {
                Preconditions.checkArgument(!obj.equals(linkedEntry.getKey()), "duplicate key: %s", obj);
            }
        }
        this.keySetHashCode = n4;
    }

    private static int chooseTableSize(int size) {
        int n2 = Integer.highestOneBit(size) << 1;
        Preconditions.checkArgument(n2 > 0, "table too large: %s", size);
        return n2;
    }

    private LinkedEntry<K, V>[] createEntryArray(int size) {
        return new LinkedEntry[size];
    }

    private static <K, V> LinkedEntry<K, V> newLinkedEntry(K key, V value, @Nullable LinkedEntry<K, V> next) {
        return next == null ? new TerminalEntry<K, V>(key, value) : new NonTerminalEntry<K, V>(key, value, next);
    }

    @Override
    public V get(@Nullable Object key) {
        if (key == null) {
            return null;
        }
        int n2 = Hashing.smear(key.hashCode()) & this.mask;
        for (LinkedEntry<K, V> linkedEntry = this.table[n2]; linkedEntry != null; linkedEntry = linkedEntry.next()) {
            Object k2 = linkedEntry.getKey();
            if (!key.equals(k2)) continue;
            return linkedEntry.getValue();
        }
        return null;
    }

    @Override
    public int size() {
        return this.entries.length;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        if (value == null) {
            return false;
        }
        for (LinkedEntry<K, V> linkedEntry : this.entries) {
            if (!linkedEntry.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public ImmutableSet<Map.Entry<K, V>> entrySet() {
        ImmutableSet<Map.Entry<K, V>> immutableSet = this.entrySet;
        return immutableSet == null ? (this.entrySet = new EntrySet(this)) : immutableSet;
    }

    @Override
    public ImmutableSet<K> keySet() {
        ImmutableSet<K> immutableSet = this.keySet;
        return immutableSet == null ? (this.keySet = new KeySet(this)) : immutableSet;
    }

    @Override
    public ImmutableCollection<V> values() {
        ImmutableCollection<V> immutableCollection = this.values;
        return immutableCollection == null ? (this.values = new Values(this)) : immutableCollection;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = Collections2.newStringBuilderForCollection(this.size()).append('{');
        Collections2.STANDARD_JOINER.appendTo(stringBuilder, (Object[])this.entries);
        return stringBuilder.append('}').toString();
    }

    private static class Values<V>
    extends ImmutableCollection<V> {
        final RegularImmutableMap<?, V> map;

        Values(RegularImmutableMap<?, V> map) {
            this.map = map;
        }

        @Override
        public int size() {
            return ((RegularImmutableMap)this.map).entries.length;
        }

        @Override
        public UnmodifiableIterator<V> iterator() {
            return new AbstractIndexedListIterator<V>(((RegularImmutableMap)this.map).entries.length){

                @Override
                protected V get(int index) {
                    return map.entries[index].getValue();
                }
            };
        }

        @Override
        public boolean contains(Object target) {
            return this.map.containsValue(target);
        }

        @Override
        boolean isPartialView() {
            return true;
        }
    }

    private static class KeySet<K, V>
    extends ImmutableSet.TransformedImmutableSet<Map.Entry<K, V>, K> {
        final RegularImmutableMap<K, V> map;

        KeySet(RegularImmutableMap<K, V> map) {
            super(((RegularImmutableMap)map).entries, ((RegularImmutableMap)map).keySetHashCode);
            this.map = map;
        }

        @Override
        K transform(Map.Entry<K, V> element) {
            return element.getKey();
        }

        @Override
        public boolean contains(Object target) {
            return this.map.containsKey(target);
        }

        @Override
        boolean isPartialView() {
            return true;
        }
    }

    private static class EntrySet<K, V>
    extends ImmutableSet.ArrayImmutableSet<Map.Entry<K, V>> {
        final transient RegularImmutableMap<K, V> map;

        EntrySet(RegularImmutableMap<K, V> map) {
            super(((RegularImmutableMap)map).entries);
            this.map = map;
        }

        @Override
        public boolean contains(Object target) {
            if (target instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)target;
                V v2 = this.map.get(entry.getKey());
                return v2 != null && v2.equals(entry.getValue());
            }
            return false;
        }
    }

    @Immutable
    private static final class TerminalEntry<K, V>
    extends ImmutableEntry<K, V>
    implements LinkedEntry<K, V> {
        TerminalEntry(K key, V value) {
            super(key, value);
        }

        @Override
        @Nullable
        public LinkedEntry<K, V> next() {
            return null;
        }
    }

    @Immutable
    private static final class NonTerminalEntry<K, V>
    extends ImmutableEntry<K, V>
    implements LinkedEntry<K, V> {
        final LinkedEntry<K, V> next;

        NonTerminalEntry(K key, V value, LinkedEntry<K, V> next) {
            super(key, value);
            this.next = next;
        }

        @Override
        public LinkedEntry<K, V> next() {
            return this.next;
        }
    }

    private static interface LinkedEntry<K, V>
    extends Map.Entry<K, V> {
        @Nullable
        public LinkedEntry<K, V> next();
    }
}

