/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.collect;

import com.timevale.esign.paas.guava.common.annotations.GwtCompatible;
import com.timevale.esign.paas.guava.common.collect.ImmutableMap;
import com.timevale.esign.paas.guava.common.collect.ImmutableMultiset;
import com.timevale.esign.paas.guava.common.collect.ImmutableSet;
import com.timevale.esign.paas.guava.common.collect.Multiset;
import com.timevale.esign.paas.guava.common.collect.Multisets;
import com.timevale.esign.paas.guava.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;

@GwtCompatible(serializable=true)
class RegularImmutableMultiset<E>
extends ImmutableMultiset<E> {
    private final transient ImmutableMap<E, Integer> map;
    private final transient int size;

    RegularImmutableMultiset(ImmutableMap<E, Integer> map, int size) {
        this.map = map;
        this.size = size;
    }

    @Override
    boolean isPartialView() {
        return this.map.isPartialView();
    }

    @Override
    public int count(@Nullable Object element) {
        Integer n2 = this.map.get(element);
        return n2 == null ? 0 : n2;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(@Nullable Object element) {
        return this.map.containsKey(element);
    }

    @Override
    public ImmutableSet<E> elementSet() {
        return this.map.keySet();
    }

    @Override
    UnmodifiableIterator<Multiset.Entry<E>> entryIterator() {
        final Iterator iterator = ((ImmutableSet)this.map.entrySet()).iterator();
        return new UnmodifiableIterator<Multiset.Entry<E>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Multiset.Entry<E> next() {
                Map.Entry entry = (Map.Entry)iterator.next();
                return Multisets.immutableEntry(entry.getKey(), (Integer)entry.getValue());
            }
        };
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    int distinctElements() {
        return this.map.size();
    }
}

