/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.eventbus;

import com.timevale.esign.paas.guava.common.annotations.Beta;
import com.timevale.esign.paas.guava.common.annotations.VisibleForTesting;
import com.timevale.esign.paas.guava.common.base.Supplier;
import com.timevale.esign.paas.guava.common.base.Throwables;
import com.timevale.esign.paas.guava.common.cache.Cache;
import com.timevale.esign.paas.guava.common.cache.CacheBuilder;
import com.timevale.esign.paas.guava.common.cache.CacheLoader;
import com.timevale.esign.paas.guava.common.collect.Lists;
import com.timevale.esign.paas.guava.common.collect.Multimap;
import com.timevale.esign.paas.guava.common.collect.Multimaps;
import com.timevale.esign.paas.guava.common.collect.SetMultimap;
import com.timevale.esign.paas.guava.common.collect.Sets;
import com.timevale.esign.paas.guava.common.eventbus.AnnotatedHandlerFinder;
import com.timevale.esign.paas.guava.common.eventbus.DeadEvent;
import com.timevale.esign.paas.guava.common.eventbus.EventHandler;
import com.timevale.esign.paas.guava.common.eventbus.HandlerFindingStrategy;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;

@Beta
public class EventBus {
    private final SetMultimap<Class<?>, EventHandler> handlersByType = Multimaps.newSetMultimap(new ConcurrentHashMap(), new Supplier<Set<EventHandler>>(){

        @Override
        public Set<EventHandler> get() {
            return new CopyOnWriteArraySet<EventHandler>();
        }
    });
    private final Logger logger;
    private final HandlerFindingStrategy finder = new AnnotatedHandlerFinder();
    private final ThreadLocal<ConcurrentLinkedQueue<EventWithHandler>> eventsToDispatch = new ThreadLocal<ConcurrentLinkedQueue<EventWithHandler>>(){

        @Override
        protected ConcurrentLinkedQueue<EventWithHandler> initialValue() {
            return new ConcurrentLinkedQueue<EventWithHandler>();
        }
    };
    private final ThreadLocal<Boolean> isDispatching = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private Cache<Class<?>, Set<Class<?>>> flattenHierarchyCache = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<?>, Set<Class<?>>>(){

        @Override
        public Set<Class<?>> load(Class<?> concreteClass) throws Exception {
            LinkedList<Class<?>> linkedList = Lists.newLinkedList();
            HashSet<Class<?>> hashSet = Sets.newHashSet();
            linkedList.add(concreteClass);
            while (!linkedList.isEmpty()) {
                Class clazz = (Class)linkedList.remove(0);
                hashSet.add(clazz);
                Class clazz2 = clazz.getSuperclass();
                if (clazz2 != null) {
                    linkedList.add(clazz2);
                }
                for (Class<?> clazz3 : clazz.getInterfaces()) {
                    linkedList.add(clazz3);
                }
            }
            return hashSet;
        }
    });

    public EventBus() {
        this("default");
    }

    public EventBus(String identifier) {
        this.logger = Logger.getLogger(EventBus.class.getName() + "." + identifier);
    }

    public void register(Object object) {
        this.handlersByType.putAll(this.finder.findAllHandlers(object));
    }

    public void unregister(Object object) {
        Multimap<Class<?>, EventHandler> multimap = this.finder.findAllHandlers(object);
        for (Map.Entry<Class<?>, Collection<EventHandler>> entry : multimap.asMap().entrySet()) {
            Set<EventHandler> set = this.getHandlersForEventType(entry.getKey());
            Collection<EventHandler> collection = entry.getValue();
            if (set == null || !set.containsAll(entry.getValue())) {
                throw new IllegalArgumentException("missing event handler for an annotated method. Is " + object + " registered?");
            }
            set.removeAll(collection);
        }
    }

    public void post(Object event) {
        Set<Class<?>> set = this.flattenHierarchy(event.getClass());
        boolean bl2 = false;
        for (Class<?> clazz : set) {
            Set<EventHandler> set2 = this.getHandlersForEventType(clazz);
            if (set2 == null || set2.isEmpty()) continue;
            bl2 = true;
            for (EventHandler eventHandler : set2) {
                this.enqueueEvent(event, eventHandler);
            }
        }
        if (!bl2 && !(event instanceof DeadEvent)) {
            this.post(new DeadEvent(this, event));
        }
        this.dispatchQueuedEvents();
    }

    protected void enqueueEvent(Object event, EventHandler handler) {
        this.eventsToDispatch.get().offer(new EventWithHandler(event, handler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchQueuedEvents() {
        if (this.isDispatching.get().booleanValue()) {
            return;
        }
        this.isDispatching.set(true);
        try {
            EventWithHandler eventWithHandler;
            while ((eventWithHandler = this.eventsToDispatch.get().poll()) != null) {
                this.dispatch(eventWithHandler.event, eventWithHandler.handler);
            }
        }
        finally {
            this.isDispatching.set(false);
        }
    }

    protected void dispatch(Object event, EventHandler wrapper) {
        try {
            wrapper.handleEvent(event);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.logger.log(Level.SEVERE, "Could not dispatch event: " + event + " to handler " + wrapper, invocationTargetException);
        }
    }

    Set<EventHandler> getHandlersForEventType(Class<?> type) {
        return this.handlersByType.get(type);
    }

    protected Set<EventHandler> newHandlerSet() {
        return new CopyOnWriteArraySet<EventHandler>();
    }

    @VisibleForTesting
    Set<Class<?>> flattenHierarchy(Class<?> concreteClass) {
        try {
            return this.flattenHierarchyCache.get(concreteClass);
        }
        catch (ExecutionException executionException) {
            throw Throwables.propagate(executionException.getCause());
        }
    }

    static class EventWithHandler {
        final Object event;
        final EventHandler handler;

        public EventWithHandler(Object event, EventHandler handler) {
            this.event = event;
            this.handler = handler;
        }
    }
}

