/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.io;

import com.timevale.esign.paas.guava.common.annotations.Beta;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

@Beta
public final class CountingInputStream
extends FilterInputStream {
    private long count;
    private long mark = -1L;

    public CountingInputStream(InputStream in) {
        super(in);
    }

    public long getCount() {
        return this.count;
    }

    @Override
    public int read() throws IOException {
        int n2 = this.in.read();
        if (n2 != -1) {
            ++this.count;
        }
        return n2;
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        int n2 = this.in.read(b2, off, len);
        if (n2 != -1) {
            this.count += (long)n2;
        }
        return n2;
    }

    @Override
    public long skip(long n2) throws IOException {
        long l2 = this.in.skip(n2);
        this.count += l2;
        return l2;
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
        this.mark = this.count;
    }

    @Override
    public void reset() throws IOException {
        if (!this.in.markSupported()) {
            throw new IOException("Mark not supported");
        }
        if (this.mark == -1L) {
            throw new IOException("Mark not set");
        }
        this.in.reset();
        this.count = this.mark;
    }
}

