/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.io;

import java.io.IOException;

abstract class LineBuffer {
    private StringBuilder line = new StringBuilder();
    private boolean sawReturn;

    LineBuffer() {
    }

    protected void add(char[] cbuf, int off, int len) throws IOException {
        int n2 = off;
        if (this.sawReturn && len > 0 && this.finishLine(cbuf[n2] == '\n')) {
            ++n2;
        }
        int n3 = n2;
        int n4 = off + len;
        while (n2 < n4) {
            switch (cbuf[n2]) {
                case '\r': {
                    this.line.append(cbuf, n3, n2 - n3);
                    this.sawReturn = true;
                    if (n2 + 1 < n4 && this.finishLine(cbuf[n2 + 1] == '\n')) {
                        ++n2;
                    }
                    n3 = n2 + 1;
                    break;
                }
                case '\n': {
                    this.line.append(cbuf, n3, n2 - n3);
                    this.finishLine(true);
                    n3 = n2 + 1;
                }
            }
            ++n2;
        }
        this.line.append(cbuf, n3, off + len - n3);
    }

    private boolean finishLine(boolean sawNewline) throws IOException {
        this.handleLine(this.line.toString(), this.sawReturn ? (sawNewline ? "\r\n" : "\r") : (sawNewline ? "\n" : ""));
        this.line = new StringBuilder();
        this.sawReturn = false;
        return sawNewline;
    }

    protected void finish() throws IOException {
        if (this.sawReturn || this.line.length() > 0) {
            this.finishLine(false);
        }
    }

    protected abstract void handleLine(String var1, String var2) throws IOException;
}

