/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.net;

import com.timevale.esign.paas.guava.common.annotations.Beta;
import com.timevale.esign.paas.guava.common.annotations.VisibleForTesting;
import com.timevale.esign.paas.guava.common.base.Preconditions;
import com.timevale.esign.paas.guava.common.io.ByteStreams;
import com.timevale.esign.paas.guava.common.primitives.Ints;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.Nullable;

@Beta
public final class InetAddresses {
    private static final int IPV4_PART_COUNT = 4;
    private static final int IPV6_PART_COUNT = 8;
    private static final Inet4Address LOOPBACK4 = (Inet4Address)InetAddresses.forString("127.0.0.1");
    private static final Inet4Address ANY4 = (Inet4Address)InetAddresses.forString("0.0.0.0");

    private InetAddresses() {
    }

    private static Inet4Address getInet4Address(byte[] bytes) {
        Preconditions.checkArgument(bytes.length == 4, "Byte array has invalid length for an IPv4 address: %s != 4.", bytes.length);
        try {
            InetAddress inetAddress = InetAddress.getByAddress(bytes);
            if (!(inetAddress instanceof Inet4Address)) {
                throw new UnknownHostException(String.format("'%s' is not an IPv4 address.", inetAddress.getHostAddress()));
            }
            return (Inet4Address)inetAddress;
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalArgumentException(String.format("Host address '%s' is not a valid IPv4 address.", Arrays.toString(bytes)), unknownHostException);
        }
    }

    public static InetAddress forString(String ipString) {
        byte[] byArray = InetAddresses.ipStringToBytes(ipString);
        if (byArray == null) {
            throw new IllegalArgumentException(String.format("'%s' is not an IP string literal.", ipString));
        }
        try {
            return InetAddress.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalArgumentException(String.format("'%s' is extremely broken.", ipString), unknownHostException);
        }
    }

    public static boolean isInetAddress(String ipString) {
        return InetAddresses.ipStringToBytes(ipString) != null;
    }

    private static byte[] ipStringToBytes(String ipString) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i2 = 0; i2 < ipString.length(); ++i2) {
            char c2 = ipString.charAt(i2);
            if (c2 == '.') {
                bl3 = true;
                continue;
            }
            if (c2 == ':') {
                if (bl3) {
                    return null;
                }
                bl2 = true;
                continue;
            }
            if (Character.digit(c2, 16) != -1) continue;
            return null;
        }
        if (bl2) {
            if (bl3 && (ipString = InetAddresses.convertDottedQuadToHex(ipString)) == null) {
                return null;
            }
            return InetAddresses.textToNumericFormatV6(ipString);
        }
        if (bl3) {
            return InetAddresses.textToNumericFormatV4(ipString);
        }
        return null;
    }

    private static byte[] textToNumericFormatV4(String ipString) {
        String[] stringArray = ipString.split("\\.", 5);
        if (stringArray.length != 4) {
            return null;
        }
        byte[] byArray = new byte[4];
        try {
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                byArray[i2] = InetAddresses.parseOctet(stringArray[i2]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return byArray;
    }

    private static byte[] textToNumericFormatV6(String ipString) {
        int n2;
        int n3;
        String[] stringArray = ipString.split(":", 10);
        if (stringArray.length < 3 || stringArray.length > 9) {
            return null;
        }
        int n4 = -1;
        for (n3 = 1; n3 < stringArray.length - 1; ++n3) {
            if (stringArray[n3].length() != 0) continue;
            if (n4 >= 0) {
                return null;
            }
            n4 = n3;
        }
        if (n4 >= 0) {
            n3 = n4;
            n2 = stringArray.length - n4 - 1;
            if (stringArray[0].length() == 0 && --n3 != 0) {
                return null;
            }
            if (stringArray[stringArray.length - 1].length() == 0 && --n2 != 0) {
                return null;
            }
        } else {
            n3 = stringArray.length;
            n2 = 0;
        }
        int n5 = 8 - (n3 + n2);
        if (!(n4 < 0 ? n5 == 0 : n5 >= 1)) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(16);
        try {
            int n6;
            for (n6 = 0; n6 < n3; ++n6) {
                byteBuffer.putShort(InetAddresses.parseHextet(stringArray[n6]));
            }
            for (n6 = 0; n6 < n5; ++n6) {
                byteBuffer.putShort((short)0);
            }
            for (n6 = n2; n6 > 0; --n6) {
                byteBuffer.putShort(InetAddresses.parseHextet(stringArray[stringArray.length - n6]));
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return byteBuffer.array();
    }

    private static String convertDottedQuadToHex(String ipString) {
        int n2 = ipString.lastIndexOf(58);
        String string = ipString.substring(0, n2 + 1);
        String string2 = ipString.substring(n2 + 1);
        byte[] byArray = InetAddresses.textToNumericFormatV4(string2);
        if (byArray == null) {
            return null;
        }
        String string3 = Integer.toHexString((byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF);
        String string4 = Integer.toHexString((byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF);
        return string + string3 + ":" + string4;
    }

    private static byte parseOctet(String ipPart) {
        int n2 = Integer.parseInt(ipPart);
        if (n2 > 255 || ipPart.startsWith("0") && ipPart.length() > 1) {
            throw new NumberFormatException();
        }
        return (byte)n2;
    }

    private static short parseHextet(String ipPart) {
        int n2 = Integer.parseInt(ipPart, 16);
        if (n2 > 65535) {
            throw new NumberFormatException();
        }
        return (short)n2;
    }

    public static String toAddrString(InetAddress ip) {
        Preconditions.checkNotNull(ip);
        if (ip instanceof Inet4Address) {
            return ip.getHostAddress();
        }
        Preconditions.checkArgument(ip instanceof Inet6Address);
        byte[] byArray = ip.getAddress();
        int[] nArray = new int[8];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = Ints.fromBytes((byte)0, (byte)0, byArray[2 * i2], byArray[2 * i2 + 1]);
        }
        InetAddresses.compressLongestRunOfZeroes(nArray);
        return InetAddresses.hextetsToIPv6String(nArray);
    }

    private static void compressLongestRunOfZeroes(int[] hextets) {
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        for (int i2 = 0; i2 < hextets.length + 1; ++i2) {
            if (i2 < hextets.length && hextets[i2] == 0) {
                if (n4 >= 0) continue;
                n4 = i2;
                continue;
            }
            if (n4 < 0) continue;
            int n5 = i2 - n4;
            if (n5 > n3) {
                n2 = n4;
                n3 = n5;
            }
            n4 = -1;
        }
        if (n3 >= 2) {
            Arrays.fill(hextets, n2, n2 + n3, -1);
        }
    }

    private static String hextetsToIPv6String(int[] hextets) {
        StringBuilder stringBuilder = new StringBuilder(39);
        boolean bl2 = false;
        for (int i2 = 0; i2 < hextets.length; ++i2) {
            boolean bl3;
            boolean bl4 = bl3 = hextets[i2] >= 0;
            if (bl3) {
                if (bl2) {
                    stringBuilder.append(':');
                }
                stringBuilder.append(Integer.toHexString(hextets[i2]));
            } else if (i2 == 0 || bl2) {
                stringBuilder.append("::");
            }
            bl2 = bl3;
        }
        return stringBuilder.toString();
    }

    public static String toUriString(InetAddress ip) {
        if (ip instanceof Inet6Address) {
            return "[" + InetAddresses.toAddrString(ip) + "]";
        }
        return InetAddresses.toAddrString(ip);
    }

    public static InetAddress forUriString(String hostAddr) {
        Preconditions.checkNotNull(hostAddr);
        Preconditions.checkArgument(hostAddr.length() > 0, "host string is empty");
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddresses.forString(hostAddr);
            if (inetAddress instanceof Inet4Address) {
                return inetAddress;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (!hostAddr.startsWith("[") || !hostAddr.endsWith("]")) {
            throw new IllegalArgumentException("Not a valid address: \"" + hostAddr + '\"');
        }
        inetAddress = InetAddresses.forString(hostAddr.substring(1, hostAddr.length() - 1));
        if (inetAddress instanceof Inet6Address) {
            return inetAddress;
        }
        throw new IllegalArgumentException("Not a valid address: \"" + hostAddr + '\"');
    }

    public static boolean isUriInetAddress(String ipString) {
        try {
            InetAddresses.forUriString(ipString);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static boolean isCompatIPv4Address(Inet6Address ip) {
        if (!ip.isIPv4CompatibleAddress()) {
            return false;
        }
        byte[] byArray = ip.getAddress();
        return byArray[12] != 0 || byArray[13] != 0 || byArray[14] != 0 || byArray[15] != 0 && byArray[15] != 1;
    }

    public static Inet4Address getCompatIPv4Address(Inet6Address ip) {
        Preconditions.checkArgument(InetAddresses.isCompatIPv4Address(ip), "Address '%s' is not IPv4-compatible.", InetAddresses.toAddrString(ip));
        return InetAddresses.getInet4Address(InetAddresses.copyOfRange(ip.getAddress(), 12, 16));
    }

    public static boolean is6to4Address(Inet6Address ip) {
        byte[] byArray = ip.getAddress();
        return byArray[0] == 32 && byArray[1] == 2;
    }

    public static Inet4Address get6to4IPv4Address(Inet6Address ip) {
        Preconditions.checkArgument(InetAddresses.is6to4Address(ip), "Address '%s' is not a 6to4 address.", InetAddresses.toAddrString(ip));
        return InetAddresses.getInet4Address(InetAddresses.copyOfRange(ip.getAddress(), 2, 6));
    }

    public static boolean isTeredoAddress(Inet6Address ip) {
        byte[] byArray = ip.getAddress();
        return byArray[0] == 32 && byArray[1] == 1 && byArray[2] == 0 && byArray[3] == 0;
    }

    public static TeredoInfo getTeredoInfo(Inet6Address ip) {
        Preconditions.checkArgument(InetAddresses.isTeredoAddress(ip), "Address '%s' is not a Teredo address.", InetAddresses.toAddrString(ip));
        byte[] byArray = ip.getAddress();
        Inet4Address inet4Address = InetAddresses.getInet4Address(InetAddresses.copyOfRange(byArray, 4, 8));
        int n2 = ByteStreams.newDataInput(byArray, 8).readShort() & 0xFFFF;
        int n3 = ~ByteStreams.newDataInput(byArray, 10).readShort() & 0xFFFF;
        byte[] byArray2 = InetAddresses.copyOfRange(byArray, 12, 16);
        for (int i2 = 0; i2 < byArray2.length; ++i2) {
            byArray2[i2] = ~byArray2[i2];
        }
        Inet4Address inet4Address2 = InetAddresses.getInet4Address(byArray2);
        return new TeredoInfo(inet4Address, inet4Address2, n3, n2);
    }

    public static boolean isIsatapAddress(Inet6Address ip) {
        if (InetAddresses.isTeredoAddress(ip)) {
            return false;
        }
        byte[] byArray = ip.getAddress();
        if ((byArray[8] | 3) != 3) {
            return false;
        }
        return byArray[9] == 0 && byArray[10] == 94 && byArray[11] == -2;
    }

    public static Inet4Address getIsatapIPv4Address(Inet6Address ip) {
        Preconditions.checkArgument(InetAddresses.isIsatapAddress(ip), "Address '%s' is not an ISATAP address.", InetAddresses.toAddrString(ip));
        return InetAddresses.getInet4Address(InetAddresses.copyOfRange(ip.getAddress(), 12, 16));
    }

    public static boolean hasEmbeddedIPv4ClientAddress(Inet6Address ip) {
        return InetAddresses.isCompatIPv4Address(ip) || InetAddresses.is6to4Address(ip) || InetAddresses.isTeredoAddress(ip);
    }

    public static Inet4Address getEmbeddedIPv4ClientAddress(Inet6Address ip) {
        if (InetAddresses.isCompatIPv4Address(ip)) {
            return InetAddresses.getCompatIPv4Address(ip);
        }
        if (InetAddresses.is6to4Address(ip)) {
            return InetAddresses.get6to4IPv4Address(ip);
        }
        if (InetAddresses.isTeredoAddress(ip)) {
            return InetAddresses.getTeredoInfo(ip).getClient();
        }
        throw new IllegalArgumentException(String.format("'%s' has no embedded IPv4 address.", InetAddresses.toAddrString(ip)));
    }

    public static boolean isMappedIPv4Address(String ipString) {
        byte[] byArray = InetAddresses.ipStringToBytes(ipString);
        if (byArray != null && byArray.length == 16) {
            int n2;
            for (n2 = 0; n2 < 10; ++n2) {
                if (byArray[n2] == 0) continue;
                return false;
            }
            for (n2 = 10; n2 < 12; ++n2) {
                if (byArray[n2] == -1) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Inet4Address getCoercedIPv4Address(InetAddress ip) {
        if (ip instanceof Inet4Address) {
            return (Inet4Address)ip;
        }
        byte[] byArray = ip.getAddress();
        boolean bl2 = true;
        for (int i2 = 0; i2 < 15; ++i2) {
            if (byArray[i2] == 0) continue;
            bl2 = false;
            break;
        }
        if (bl2 && byArray[15] == 1) {
            return LOOPBACK4;
        }
        if (bl2 && byArray[15] == 0) {
            return ANY4;
        }
        Inet6Address inet6Address = (Inet6Address)ip;
        long l2 = 0L;
        l2 = InetAddresses.hasEmbeddedIPv4ClientAddress(inet6Address) ? (long)InetAddresses.getEmbeddedIPv4ClientAddress(inet6Address).hashCode() : ByteBuffer.wrap(inet6Address.getAddress(), 0, 8).getLong();
        int n2 = InetAddresses.hash64To32(l2);
        if ((n2 |= 0xE0000000) == -1) {
            n2 = -2;
        }
        return InetAddresses.getInet4Address(Ints.toByteArray(n2));
    }

    @VisibleForTesting
    static int hash64To32(long key) {
        key = (key ^ 0xFFFFFFFFFFFFFFFFL) + (key << 18);
        key ^= key >>> 31;
        key *= 21L;
        key ^= key >>> 11;
        key += key << 6;
        key ^= key >>> 22;
        return (int)key;
    }

    public static int coerceToInteger(InetAddress ip) {
        return ByteStreams.newDataInput(InetAddresses.getCoercedIPv4Address(ip).getAddress()).readInt();
    }

    public static Inet4Address fromInteger(int address) {
        return InetAddresses.getInet4Address(Ints.toByteArray(address));
    }

    public static InetAddress fromLittleEndianByteArray(byte[] addr) throws UnknownHostException {
        byte[] byArray = new byte[addr.length];
        for (int i2 = 0; i2 < addr.length; ++i2) {
            byArray[i2] = addr[addr.length - i2 - 1];
        }
        return InetAddress.getByAddress(byArray);
    }

    public static InetAddress increment(InetAddress address) {
        int n2;
        byte[] byArray = address.getAddress();
        for (n2 = byArray.length - 1; n2 >= 0 && byArray[n2] == -1; --n2) {
            byArray[n2] = 0;
        }
        Preconditions.checkArgument(n2 >= 0, "Incrementing " + address + " would wrap.");
        int n3 = n2;
        byArray[n3] = (byte)(byArray[n3] + 1);
        try {
            return InetAddress.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            throw new AssertionError((Object)unknownHostException);
        }
    }

    public static boolean isMaximum(InetAddress address) {
        byte[] byArray = address.getAddress();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] == -1) continue;
            return false;
        }
        return true;
    }

    private static byte[] copyOfRange(byte[] original, int from, int to) {
        Preconditions.checkNotNull(original);
        int n2 = Math.min(to, original.length);
        byte[] byArray = new byte[to - from];
        System.arraycopy(original, from, byArray, 0, n2 - from);
        return byArray;
    }

    @Beta
    public static final class TeredoInfo {
        private final Inet4Address server;
        private final Inet4Address client;
        private final int port;
        private final int flags;

        public TeredoInfo(@Nullable Inet4Address server, @Nullable Inet4Address client, int port, int flags) {
            Preconditions.checkArgument(port >= 0 && port <= 65535, "port '%s' is out of range (0 <= port <= 0xffff)", port);
            Preconditions.checkArgument(flags >= 0 && flags <= 65535, "flags '%s' is out of range (0 <= flags <= 0xffff)", flags);
            this.server = server != null ? server : ANY4;
            this.client = client != null ? client : ANY4;
            this.port = port;
            this.flags = flags;
        }

        public Inet4Address getServer() {
            return this.server;
        }

        public Inet4Address getClient() {
            return this.client;
        }

        public int getPort() {
            return this.port;
        }

        public int getFlags() {
            return this.flags;
        }
    }
}

