/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.util.concurrent;

import com.timevale.esign.paas.guava.common.base.Preconditions;
import com.timevale.esign.paas.guava.common.util.concurrent.ListenableFuture;
import com.timevale.esign.paas.guava.common.util.concurrent.ListenableFutureTask;
import com.timevale.esign.paas.guava.common.util.concurrent.ListeningExecutorService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

abstract class AbstractListeningExecutorService
implements ListeningExecutorService {
    AbstractListeningExecutorService() {
    }

    @Override
    public ListenableFuture<?> submit(Runnable task) {
        ListenableFutureTask<Object> listenableFutureTask = ListenableFutureTask.create(task, null);
        this.execute(listenableFutureTask);
        return listenableFutureTask;
    }

    @Override
    public <T> ListenableFuture<T> submit(Runnable task, T result) {
        ListenableFutureTask<T> listenableFutureTask = ListenableFutureTask.create(task, result);
        this.execute(listenableFutureTask);
        return listenableFutureTask;
    }

    @Override
    public <T> ListenableFuture<T> submit(Callable<T> task) {
        ListenableFutureTask<T> listenableFutureTask = ListenableFutureTask.create(task);
        this.execute(listenableFutureTask);
        return listenableFutureTask;
    }

    private <T> T doInvokeAny(Collection<? extends Callable<T>> tasks, boolean timed, long nanos) throws InterruptedException, ExecutionException, TimeoutException {
        ExecutionException executionException;
        ArrayList arrayList;
        block15: {
            int n2 = tasks.size();
            Preconditions.checkArgument(n2 > 0);
            arrayList = new ArrayList(n2);
            ExecutorCompletionService<T> executorCompletionService = new ExecutorCompletionService<T>(this);
            executionException = null;
            long l2 = timed ? System.nanoTime() : 0L;
            Iterator<Callable<T>> iterator = tasks.iterator();
            arrayList.add(executorCompletionService.submit(iterator.next()));
            --n2;
            int n3 = 1;
            while (true) {
                Object v2;
                Future future;
                if ((future = executorCompletionService.poll()) == null) {
                    if (n2 > 0) {
                        --n2;
                        arrayList.add(executorCompletionService.submit(iterator.next()));
                        ++n3;
                    } else {
                        if (n3 == 0) break;
                        if (timed) {
                            future = executorCompletionService.poll(nanos, TimeUnit.NANOSECONDS);
                            if (future == null) {
                                throw new TimeoutException();
                            }
                            long l3 = System.nanoTime();
                            nanos -= l3 - l2;
                            l2 = l3;
                        } else {
                            future = executorCompletionService.take();
                        }
                    }
                }
                if (future == null) continue;
                --n3;
                try {
                    v2 = future.get();
                }
                catch (ExecutionException executionException2) {
                    executionException = executionException2;
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    executionException = new ExecutionException(runtimeException);
                    continue;
                }
                return (T)v2;
                break;
            }
            if (executionException != null) break block15;
            executionException = new ExecutionException(null);
        }
        throw executionException;
        finally {
            for (Future future : arrayList) {
                future.cancel(true);
            }
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        try {
            return this.doInvokeAny(tasks, false, 0L);
        }
        catch (TimeoutException timeoutException) {
            throw new AssertionError();
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.doInvokeAny(tasks, true, unit.toNanos(timeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        if (tasks == null) {
            throw new NullPointerException();
        }
        ArrayList<ListenableFutureTask<T>> arrayList = new ArrayList<ListenableFutureTask<T>>(tasks.size());
        boolean bl2 = false;
        try {
            for (Callable<T> object : tasks) {
                ListenableFutureTask<T> listenableFutureTask = ListenableFutureTask.create(object);
                arrayList.add(listenableFutureTask);
                this.execute(listenableFutureTask);
            }
            for (Future future : arrayList) {
                if (future.isDone()) continue;
                try {
                    future.get();
                }
                catch (CancellationException cancellationException) {
                }
                catch (ExecutionException executionException) {}
            }
            bl2 = true;
            ArrayList<ListenableFutureTask<T>> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            if (!bl2) {
                for (Future future : arrayList) {
                    future.cancel(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        if (tasks == null || unit == null) {
            throw new NullPointerException();
        }
        long l2 = unit.toNanos(timeout);
        ArrayList<Future<T>> arrayList = new ArrayList<Future<T>>(tasks.size());
        boolean bl2 = false;
        try {
            for (Callable<T> callable : tasks) {
                arrayList.add(ListenableFutureTask.create(callable));
            }
            long l3 = System.nanoTime();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.execute((Runnable)iterator.next());
                long l4 = System.nanoTime();
                l3 = l4;
                if ((l2 -= l4 - l3) > 0L) continue;
                ArrayList<Future<T>> arrayList2 = arrayList;
                return arrayList2;
            }
            for (Future object : arrayList) {
                if (object.isDone()) continue;
                if (l2 <= 0L) {
                    ArrayList<Future<T>> arrayList3 = arrayList;
                    return arrayList3;
                }
                try {
                    object.get(l2, TimeUnit.NANOSECONDS);
                }
                catch (CancellationException cancellationException) {
                }
                catch (ExecutionException executionException) {
                }
                catch (TimeoutException timeoutException) {
                    ArrayList<Future<T>> arrayList4 = arrayList;
                    if (!bl2) {
                        for (Future future : arrayList) {
                            future.cancel(true);
                        }
                    }
                    return arrayList4;
                }
                long l5 = System.nanoTime();
                l2 -= l5 - l3;
                l3 = l5;
            }
            bl2 = true;
            ArrayList<Future<T>> arrayList5 = arrayList;
            return arrayList5;
        }
        finally {
            if (!bl2) {
                for (Future future : arrayList) {
                    future.cancel(true);
                }
            }
        }
    }
}

