/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.seal.sdk.util;

import com.timevale.esign.paas.seal.sdk.enums.SealColor;
import com.timevale.esign.paas.seal.sdk.exception.SealSdkException;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageCommonUtil {
    private static final Logger log = LoggerFactory.getLogger(ImageCommonUtil.class);
    private static final int DEFAULT_CVALUE = 255;
    private static final ThreadLocalRandom RANDOM = ThreadLocalRandom.current();

    public static BufferedImage setAlphaToImage(BufferedImage image, float alpha) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(), image.getHeight(), 6);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setComposite(AlphaComposite.getInstance(3, alpha));
        graphics2D.drawImage((Image)image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static BufferedImage makeOld(BufferedImage bufferedImage, SealColor color, int oldStyle) {
        BufferedImage bufferedImage2 = ImageCommonUtil.addOldWaterMark(bufferedImage, oldStyle);
        bufferedImage2 = ImageCommonUtil.gray(bufferedImage2);
        bufferedImage2 = ImageCommonUtil.compressImage(bufferedImage2, 255, color);
        return bufferedImage2;
    }

    private static BufferedImage addOldWaterMark(BufferedImage src, int oldStyle) {
        try {
            BufferedImage bufferedImage = ImageIO.read(Objects.requireNonNull(ImageCommonUtil.class.getClassLoader().getResourceAsStream("images/" + oldStyle + ".png")));
            int n2 = RANDOM.nextInt(361);
            int n3 = src.getWidth();
            int n4 = src.getHeight();
            BufferedImage bufferedImage2 = new BufferedImage(n3, n4, src.getColorModel().getTransparency());
            Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.drawImage(src.getScaledInstance(n3, n4, 4), 0, 0, null);
            graphics2D.rotate(Math.toRadians(n2), n3 >> 1, n4 >> 1);
            graphics2D.setComposite(AlphaComposite.getInstance(10, 0.6f));
            graphics2D.drawImage(bufferedImage, -n3, -n4, n3 << 2, n4 << 2, null);
            graphics2D.dispose();
            return bufferedImage2;
        }
        catch (Exception exception) {
            throw new SealSdkException(exception.getMessage(), exception);
        }
    }

    public static BufferedImage gray(BufferedImage image) {
        ColorSpace colorSpace = ColorSpace.getInstance(1003);
        ColorConvertOp colorConvertOp = new ColorConvertOp(colorSpace, null);
        return colorConvertOp.filter(image, null);
    }

    public static BufferedImage compressImage(BufferedImage srcImg, int cValue, SealColor color) {
        int n2 = srcImg.getWidth();
        int n3 = srcImg.getHeight();
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setComposite(AlphaComposite.getInstance(10, 0.6f));
        graphics2D.fillRect(0, 0, n2, n3);
        for (int i2 = srcImg.getMinX(); i2 < n2; ++i2) {
            for (int i3 = srcImg.getMinY(); i3 < n3; ++i3) {
                int n4 = srcImg.getRGB(i2, i3);
                int n5 = n4 | 0xFFFFFF;
                int n6 = (n4 & 0xFF0000) >>> 16;
                int n7 = (n4 & 0xFF00) >>> 8;
                int n8 = n4 & 0xFF;
                if (cValue == 255 && 200 > n6 && n6 > 80 && 200 > n7 && n7 > 80 && 200 > n7 && n7 > 80) {
                    if (SealColor.RED == color) {
                        bufferedImage.setRGB(i2, i3, n5 & SealColor.RED.getColor().getRGB());
                        continue;
                    }
                    if (SealColor.BLUE == color) {
                        bufferedImage.setRGB(i2, i3, n5 & SealColor.BLUE.getColor().getRGB());
                        continue;
                    }
                    if (SealColor.BLACK == color) {
                        bufferedImage.setRGB(i2, i3, n5 & SealColor.BLACK.getColor().getRGB());
                        continue;
                    }
                    if (SealColor.PURPLE != color) continue;
                    bufferedImage.setRGB(i2, i3, n5 & SealColor.PURPLE.getColor().getRGB());
                    continue;
                }
                if (cValue < 255 && (255 - n6 > cValue || 255 - n7 > cValue || 255 - n8 > cValue)) {
                    if (SealColor.RED == color) {
                        bufferedImage.setRGB(i2, i3, n5 & SealColor.RED.getColor().getRGB());
                        continue;
                    }
                    if (SealColor.BLUE == color) {
                        bufferedImage.setRGB(i2, i3, n5 & SealColor.BLUE.getColor().getRGB());
                        continue;
                    }
                    if (SealColor.BLACK == color) {
                        bufferedImage.setRGB(i2, i3, n5 & SealColor.BLACK.getColor().getRGB());
                        continue;
                    }
                    if (SealColor.PURPLE != color) continue;
                    bufferedImage.setRGB(i2, i3, n5 & SealColor.PURPLE.getColor().getRGB());
                    continue;
                }
                bufferedImage.setRGB(i2, i3, 0xFFFFFF);
            }
        }
        graphics2D.dispose();
        return bufferedImage;
    }
}

