/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.bean.request;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.timevale.esign.paas.esign.utils.exception.SuperException;
import com.timevale.esign.paas.tech.constant.ErrorCode;
import com.timevale.esign.paas.tech.enums.AuthTypeEnum;
import com.timevale.esign.paas.tech.enums.CertTimeEnum;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OfflineCreateAuthParam {
    private String organizeId;
    private String personId;
    private int authType = AuthTypeEnum.AUTH_TO_PLATFORM.getType();
    private String sealScope;
    private String fileType;
    private Long validDate;
    private CertTimeEnum certTime = CertTimeEnum.ONEYEAR;
    private String notifyUrl;
    private String transactorAccountId;
    private String identityAuthId;

    public String getOrganizeId() {
        return this.organizeId;
    }

    public void setOrganizeId(String organizeId) {
        this.organizeId = organizeId;
    }

    public String getPersonId() {
        return this.personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public int getAuthType() {
        return this.authType;
    }

    public void setAuthType(int authType) {
        this.authType = authType;
    }

    public String getSealScope() {
        return this.sealScope;
    }

    public void setSealScope(String sealScope) {
        this.sealScope = sealScope;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public Long getValidDate() {
        return this.validDate;
    }

    public void setValidDate(Long validDate) {
        this.validDate = validDate;
    }

    public void setCertTime(CertTimeEnum certTime) {
        this.certTime = certTime;
    }

    public CertTimeEnum getCertTime() {
        return this.certTime;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getTransactorAccountId() {
        return this.transactorAccountId;
    }

    public void setTransactorAccountId(String transactorAccountId) {
        this.transactorAccountId = transactorAccountId;
    }

    public String getIdentityAuthId() {
        return this.identityAuthId;
    }

    public void setIdentityAuthId(String identityAuthId) {
        this.identityAuthId = identityAuthId;
    }

    public void check() throws SuperException {
        if (StringUtils.isBlank((String)this.organizeId)) {
            throw ErrorCode.PARAM_ERROR.e("organizeId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.checkPerSonId();
        this.checkAuthType();
    }

    private void checkPerSonId() throws SuperException {
        if (AuthTypeEnum.AUTH_TO_PERSON.getType() == this.authType && StringUtils.isBlank((String)this.personId)) {
            throw ErrorCode.PARAM_ERROR.e("\u6388\u6743\u81f3\u7ecf\u529e\u4eba\u65f6\uff0c\u4e2a\u4eba\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void checkAuthType() throws SuperException {
        if (this.authType != AuthTypeEnum.AUTH_TO_PLATFORM.getType() && this.authType != AuthTypeEnum.AUTH_TO_PERSON.getType()) {
            throw ErrorCode.PARAM_ERROR.e("\u6388\u6743\u7c7b\u578bauthType\u4f20\u5165\u7684\u503c\u9519\u8bef");
        }
    }
}

