/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.service.a;

import com.google.gson.JsonObject;
import com.timevale.esign.paas.esign.utils.JsonHelper;
import com.timevale.esign.paas.esign.utils.bean.ResultUtil;
import com.timevale.esign.paas.esign.utils.exception.SuperException;
import com.timevale.esign.paas.sdk.b.e;
import com.timevale.esign.paas.seal.sdk.util.StringUtils;
import com.timevale.esign.paas.tech.bean.httpvo.FileUploadUrlResult;
import com.timevale.esign.paas.tech.bean.model.AuthFlowUrlModel;
import com.timevale.esign.paas.tech.bean.model.CancelAuthModel;
import com.timevale.esign.paas.tech.bean.model.CreateAuthModel;
import com.timevale.esign.paas.tech.bean.model.CreateLegalAuthModel;
import com.timevale.esign.paas.tech.bean.model.QueryAuthDetailModel;
import com.timevale.esign.paas.tech.bean.model.QueryAuthEffectiveInfoModel;
import com.timevale.esign.paas.tech.bean.model.UploadAuthFileModel;
import com.timevale.esign.paas.tech.bean.request.AuthEffectiveInfoParam;
import com.timevale.esign.paas.tech.bean.request.AuthFlowSignUrlParam;
import com.timevale.esign.paas.tech.bean.request.OfflineCreateAuthParam;
import com.timevale.esign.paas.tech.bean.request.OfflineCreateLegalRepAuthParam;
import com.timevale.esign.paas.tech.bean.request.OnlineCreateAuthParam;
import com.timevale.esign.paas.tech.bean.request.OnlineCreateLegalRepAuthParam;
import com.timevale.esign.paas.tech.bean.request.UploadAuthFileParam;
import com.timevale.esign.paas.tech.bean.request.UploadLegalAuthFileParam;
import com.timevale.esign.paas.tech.bean.result.AuthEffectiveInfoResult;
import com.timevale.esign.paas.tech.bean.result.AuthFlowSignUrlResult;
import com.timevale.esign.paas.tech.bean.result.AuthInfoResult;
import com.timevale.esign.paas.tech.bean.result.OfflineCreateAuthResult;
import com.timevale.esign.paas.tech.bean.result.OnlineCreateAuthResult;
import com.timevale.esign.paas.tech.bean.result.Result;
import com.timevale.esign.paas.tech.client.AbstractServiceClient;
import com.timevale.esign.paas.tech.client.HiddenOperationDelegator;
import com.timevale.esign.paas.tech.client.context.InterfaceKey;
import com.timevale.esign.paas.tech.common.Convertor;
import com.timevale.esign.paas.tech.common.FileSystemHelper;
import com.timevale.esign.paas.tech.constant.ErrorCode;
import com.timevale.esign.paas.tech.constant.ErrorException;
import com.timevale.esign.paas.tech.enums.AuthMethodEnum;
import com.timevale.esign.paas.tech.enums.AuthTypeEnum;
import com.timevale.esign.paas.tech.enums.AuthorizerTypeEnum;
import com.timevale.esign.paas.tech.service.AuthService;
import com.timevale.esign.paas.tech.service.a.a;
import com.timevale.esign.paas.tech.util.AesUtil;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class d
extends a
implements AuthService {
    private static Logger log = LoggerFactory.getLogger(d.class);

    public d() {
    }

    public d(AbstractServiceClient abstractServiceClient) {
        super(abstractServiceClient);
    }

    @Override
    public OnlineCreateAuthResult createAuth(OnlineCreateAuthParam param) {
        try {
            param.check();
            CreateAuthModel createAuthModel = (CreateAuthModel)this.vF().getContext().a(InterfaceKey.CREATE_AUTH);
            createAuthModel.setOrganizeId(param.getOrganizeId());
            createAuthModel.setPersonId(param.getPersonId());
            createAuthModel.setAuthType(param.getAuthType());
            createAuthModel.setAuthMethod(AuthMethodEnum.ONLINE_AUTH.getType());
            createAuthModel.setContact(param.getContact());
            createAuthModel.setSealScope(param.getSealScope());
            createAuthModel.setFileType(param.getFileType());
            createAuthModel.setValidDate(param.getValidDate());
            createAuthModel.setCertTime(param.getCertTime().getCertTime());
            createAuthModel.setCallbackUrl(param.getNotifyUrl());
            createAuthModel.setRedirectUrl(param.getRedirectUrl());
            createAuthModel.setSendNotice(param.isSendNotice());
            JsonObject jsonObject = HiddenOperationDelegator.request(this.vF(), createAuthModel);
            OnlineCreateAuthResult onlineCreateAuthResult = JsonHelper.fromJson(jsonObject, OnlineCreateAuthResult.class);
            if (onlineCreateAuthResult.getErrCode() != 0) {
                return ResultUtil.failed(onlineCreateAuthResult, OnlineCreateAuthResult.class);
            }
            return onlineCreateAuthResult;
        }
        catch (SuperException superException) {
            log.warn("createAuth fail msg: {}", (Object)superException.getMessage());
            return ResultUtil.failed(superException, OnlineCreateAuthResult.class);
        }
        catch (Exception exception) {
            log.warn("createAuth Exception msg: {}", (Object)exception.getMessage());
            return ResultUtil.failed(ErrorException.CREATE_AUTH_FAIL.e(exception.getMessage()), OnlineCreateAuthResult.class);
        }
    }

    @Override
    public Result cancel(String authId) {
        try {
            if (StringUtils.isBlank(authId)) {
                throw ErrorCode.PARAM_ERROR.e("\u6388\u6743id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            CancelAuthModel cancelAuthModel = (CancelAuthModel)this.vF().getContext().a(InterfaceKey.CANCEL_AUTH);
            cancelAuthModel.setAuthId(authId);
            JsonObject jsonObject = HiddenOperationDelegator.request(this.vF(), cancelAuthModel);
            Result result = JsonHelper.fromJson(jsonObject, Result.class);
            if (result.getErrCode() != 0) {
                return ResultUtil.failed(result, Result.class);
            }
            return result;
        }
        catch (SuperException superException) {
            log.warn("cancelAuth fail msg: {}", (Object)superException.getMessage());
            return ResultUtil.failed(superException, Result.class);
        }
        catch (Exception exception) {
            log.warn("cancelAuth Exception msg: {}", (Object)exception.getMessage());
            return ResultUtil.failed(ErrorException.CANCEL_AUTH_FAIL.e(exception.getMessage()), Result.class);
        }
    }

    @Override
    public AuthInfoResult queryAuth(String authId) {
        try {
            if (StringUtils.isBlank(authId)) {
                throw ErrorCode.PARAM_ERROR.e("\u6388\u6743id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            QueryAuthDetailModel queryAuthDetailModel = (QueryAuthDetailModel)this.vF().getContext().a(InterfaceKey.QUERY_AUTH_DETAIL);
            queryAuthDetailModel.setAuthId(authId);
            JsonObject jsonObject = HiddenOperationDelegator.request(this.vF(), queryAuthDetailModel);
            AuthInfoResult authInfoResult = JsonHelper.fromJson(jsonObject, AuthInfoResult.class);
            if (authInfoResult.getErrCode() != 0) {
                return ResultUtil.failed(authInfoResult, AuthInfoResult.class);
            }
            return authInfoResult;
        }
        catch (SuperException superException) {
            log.warn("queryAuthDetail fail msg: {}", (Object)superException.getMessage());
            return ResultUtil.failed(superException, AuthInfoResult.class);
        }
        catch (Exception exception) {
            log.warn("queryAuthDetail Exception msg: {}", (Object)exception.getMessage());
            return ResultUtil.failed(ErrorException.QUERY_AUTH_FAIL.e(exception.getMessage()), AuthInfoResult.class);
        }
    }

    @Override
    public AuthFlowSignUrlResult getAuthFlowUrl(AuthFlowSignUrlParam param) {
        try {
            param.check();
            AuthFlowUrlModel authFlowUrlModel = (AuthFlowUrlModel)this.vF().getContext().a(InterfaceKey.GET_SIGN_URL);
            authFlowUrlModel.setAuthId(param.getAuthId());
            authFlowUrlModel.setClientType(param.getClientType());
            authFlowUrlModel.setAppScheme(param.getAppScheme());
            authFlowUrlModel.setRedirectUrl(param.getRedirectUrl());
            authFlowUrlModel.setNeedLogin(param.getNeedLogin());
            JsonObject jsonObject = HiddenOperationDelegator.request(this.vF(), authFlowUrlModel);
            AuthFlowSignUrlResult authFlowSignUrlResult = JsonHelper.fromJson(jsonObject, AuthFlowSignUrlResult.class);
            if (authFlowSignUrlResult.getErrCode() != 0) {
                return ResultUtil.failed(authFlowSignUrlResult, AuthFlowSignUrlResult.class);
            }
            return authFlowSignUrlResult;
        }
        catch (SuperException superException) {
            log.warn("getAuthFlowUrl fail msg: {}", (Object)superException.getMessage());
            return ResultUtil.failed(superException, AuthFlowSignUrlResult.class);
        }
        catch (Exception exception) {
            log.warn("getAuthFlowUrl Exception msg: {}", (Object)exception.getMessage());
            return ResultUtil.failed(exception, AuthFlowSignUrlResult.class);
        }
    }

    @Override
    public OfflineCreateAuthResult createAuthOffline(OfflineCreateAuthParam param) {
        try {
            param.check();
            CreateAuthModel createAuthModel = (CreateAuthModel)this.vF().getContext().a(InterfaceKey.CREATE_AUTH);
            createAuthModel.setOrganizeId(param.getOrganizeId());
            createAuthModel.setPersonId(param.getPersonId());
            createAuthModel.setAuthType(param.getAuthType());
            createAuthModel.setAuthMethod(AuthMethodEnum.OFFLINE_AUTH.getType());
            createAuthModel.setSealScope(param.getSealScope());
            createAuthModel.setFileType(param.getFileType());
            createAuthModel.setValidDate(param.getValidDate());
            createAuthModel.setCertTime(param.getCertTime().getCertTime());
            createAuthModel.setCallbackUrl(param.getNotifyUrl());
            createAuthModel.setTransactorAccountId(param.getTransactorAccountId());
            createAuthModel.setIdentityAuthId(param.getIdentityAuthId());
            JsonObject jsonObject = HiddenOperationDelegator.request(this.vF(), createAuthModel);
            OfflineCreateAuthResult offlineCreateAuthResult = JsonHelper.fromJson(jsonObject, OfflineCreateAuthResult.class);
            if (offlineCreateAuthResult.getErrCode() != 0) {
                return ResultUtil.failed(offlineCreateAuthResult, OfflineCreateAuthResult.class);
            }
            return offlineCreateAuthResult;
        }
        catch (SuperException superException) {
            log.warn("createAuthOffline fail msg: {}", (Object)superException.getMessage());
            return ResultUtil.failed(superException, OfflineCreateAuthResult.class);
        }
        catch (Exception exception) {
            log.warn("createAuthOffline Exception msg: {}", (Object)exception.getMessage());
            return ResultUtil.failed(ErrorException.CREATE_AUTH_FAIL.e(exception.getMessage()), OfflineCreateAuthResult.class);
        }
    }

    @Override
    public Result uploadAuthFile(UploadAuthFileParam param) {
        try {
            String[] stringArray;
            param.check();
            String string = null;
            if (StringUtils.isNotBlank(param.getFileName()) && !(string = param.getFileName()).endsWith(".pdf") && !string.endsWith(".PDF")) {
                string = string + ".pdf";
            }
            if (StringUtils.isBlank(string) && (param.getStreamFile() == null || param.getStreamFile().length == 0)) {
                stringArray = param.getSrcPdfFile().split("/");
                string = stringArray[stringArray.length - 1];
            }
            if (StringUtils.isBlank(string)) {
                string = "stream.pdf";
            }
            stringArray = e.ac(param.getBytes());
            FileUploadUrlResult fileUploadUrlResult = FileSystemHelper.getUploadUrl(this.vF(), (String)stringArray, string);
            if (StringUtils.isBlank(fileUploadUrlResult.getFileKey()) || StringUtils.isBlank(fileUploadUrlResult.getUrl())) {
                throw ErrorException.FILE_UPLOAD_ERROR.e();
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("Content-MD5", (String)stringArray);
            hashMap.put("Content-Type", "application/octet-stream");
            FileSystemHelper.upload(fileUploadUrlResult.getUrl(), param.getBytes(), hashMap);
            UploadAuthFileModel uploadAuthFileModel = (UploadAuthFileModel)this.vF().getContext().a(InterfaceKey.UPLOAD_AUTH_FILE);
            uploadAuthFileModel.setFileId(fileUploadUrlResult.getFileKey());
            uploadAuthFileModel.setAuthId(param.getAuthId());
            JsonObject jsonObject = HiddenOperationDelegator.request(this.vF(), uploadAuthFileModel);
            return JsonHelper.fromJson(jsonObject, Result.class);
        }
        catch (SuperException superException) {
            log.warn("uploadAuthFile fail msg: {}", (Object)superException.getMessage());
            return ResultUtil.failed(superException, Result.class);
        }
        catch (Exception exception) {
            log.warn("uploadAuthFile Exception msg: {}", (Object)exception.getMessage());
            return ResultUtil.failed(ErrorException.AUTH_FILE_UPLOAD_ERROR.e(exception.getMessage()), Result.class);
        }
    }

    @Override
    public OnlineCreateAuthResult createLegalAuth(OnlineCreateLegalRepAuthParam param) {
        try {
            param.check();
            CreateLegalAuthModel createLegalAuthModel = (CreateLegalAuthModel)this.vF().getContext().a(InterfaceKey.PAAS_CREATE_LEGAL_AUTH);
            if (Boolean.TRUE.equals(param.getEncrypt())) {
                createLegalAuthModel.setEncrypt(param.getEncrypt());
                createLegalAuthModel.setEncryptData(AesUtil.encrypt(JsonHelper.toJson(Convertor.convert(param)), this.vF().getContext().vk().getProjectSecret()));
            } else {
                createLegalAuthModel.setAccount(Convertor.convert(param));
            }
            createLegalAuthModel.setOrganizeId(param.getOrganizeId());
            createLegalAuthModel.setEncrypt(param.getEncrypt());
            createLegalAuthModel.setContact(param.getContact());
            createLegalAuthModel.setSendNotice(param.isSendNotice());
            createLegalAuthModel.setAuthType(param.getAuthType());
            createLegalAuthModel.setPersonId(param.getPersonId());
            createLegalAuthModel.setSealScope(param.getSealScope());
            createLegalAuthModel.setFileType(param.getFileType());
            createLegalAuthModel.setNotifyUrl(param.getNotifyUrl());
            createLegalAuthModel.setRedirectUrl(param.getRedirectUrl());
            createLegalAuthModel.setCertTime(param.getCertTime().getCertTime());
            createLegalAuthModel.setAuthMethod(AuthMethodEnum.ONLINE_AUTH.getType());
            JsonObject jsonObject = HiddenOperationDelegator.request(this.vF(), createLegalAuthModel);
            OnlineCreateAuthResult onlineCreateAuthResult = JsonHelper.fromJson(jsonObject, OnlineCreateAuthResult.class);
            if (onlineCreateAuthResult.getErrCode() != 0) {
                return ResultUtil.failed(onlineCreateAuthResult, OnlineCreateAuthResult.class);
            }
            return onlineCreateAuthResult;
        }
        catch (SuperException superException) {
            log.warn("createLegalAuth fail msg: {}", (Object)superException.getMessage());
            return ResultUtil.failed(superException, OnlineCreateAuthResult.class);
        }
        catch (Exception exception) {
            log.warn("createLegalAuth Exception msg: {}", (Object)exception.getMessage());
            return ResultUtil.failed(ErrorException.CREATE_AUTH_FAIL.e(exception.getMessage()), OnlineCreateAuthResult.class);
        }
    }

    @Override
    public OfflineCreateAuthResult createOfflineLegalAuth(OfflineCreateLegalRepAuthParam param) {
        try {
            param.check();
            CreateLegalAuthModel createLegalAuthModel = (CreateLegalAuthModel)this.vF().getContext().a(InterfaceKey.PAAS_CREATE_LEGAL_AUTH);
            if (Boolean.TRUE.equals(param.getEncrypt())) {
                createLegalAuthModel.setEncrypt(param.getEncrypt());
                createLegalAuthModel.setEncryptData(AesUtil.encrypt(JsonHelper.toJson(Convertor.convert(param)), this.vF().getContext().vk().getProjectSecret()));
            } else {
                createLegalAuthModel.setAccount(Convertor.convert(param));
            }
            createLegalAuthModel.setOrganizeId(param.getOrganizeId());
            createLegalAuthModel.setEncrypt(param.getEncrypt());
            createLegalAuthModel.setAuthType(param.getAuthType());
            createLegalAuthModel.setPersonId(param.getPersonId());
            createLegalAuthModel.setSealScope(param.getSealScope());
            createLegalAuthModel.setFileType(param.getFileType());
            createLegalAuthModel.setNotifyUrl(param.getNotifyUrl());
            createLegalAuthModel.setIdentityAuthId(param.getIdentityAuthId());
            createLegalAuthModel.setTransactorAccountId(param.getTransactorAccountId());
            createLegalAuthModel.setCertTime(param.getCertTime().getCertTime());
            createLegalAuthModel.setAuthMethod(AuthMethodEnum.OFFLINE_AUTH.getType());
            JsonObject jsonObject = HiddenOperationDelegator.request(this.vF(), createLegalAuthModel);
            OfflineCreateAuthResult offlineCreateAuthResult = JsonHelper.fromJson(jsonObject, OfflineCreateAuthResult.class);
            if (offlineCreateAuthResult.getErrCode() != 0) {
                return ResultUtil.failed(offlineCreateAuthResult, OfflineCreateAuthResult.class);
            }
            return offlineCreateAuthResult;
        }
        catch (SuperException superException) {
            log.warn("createOfflineLegalAuth fail msg: {}", (Object)superException.getMessage());
            return ResultUtil.failed(superException, OfflineCreateAuthResult.class);
        }
        catch (Exception exception) {
            log.warn("createOfflineLegalAuth Exception msg: {}", (Object)exception.getMessage());
            return ResultUtil.failed(ErrorException.CREATE_AUTH_FAIL.e(exception.getMessage()), OfflineCreateAuthResult.class);
        }
    }

    @Override
    public Result uploadLegalAuthFile(UploadLegalAuthFileParam param) {
        try {
            String[] stringArray;
            param.check();
            String string = null;
            if (StringUtils.isNotBlank(param.getFileName()) && !(string = param.getFileName()).endsWith(".pdf") && !string.endsWith(".PDF")) {
                string = string + ".pdf";
            }
            if (StringUtils.isBlank(string) && (param.getStreamFile() == null || param.getStreamFile().length == 0)) {
                stringArray = param.getSrcPdfFile().split("/");
                string = stringArray[stringArray.length - 1];
            }
            if (StringUtils.isBlank(string)) {
                string = "stream.pdf";
            }
            stringArray = e.ac(param.getBytes());
            FileUploadUrlResult fileUploadUrlResult = FileSystemHelper.getUploadUrl(this.vF(), (String)stringArray, string);
            if (StringUtils.isBlank(fileUploadUrlResult.getFileKey()) || StringUtils.isBlank(fileUploadUrlResult.getUrl())) {
                throw ErrorException.FILE_UPLOAD_ERROR.e();
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("Content-MD5", (String)stringArray);
            hashMap.put("Content-Type", "application/octet-stream");
            FileSystemHelper.upload(fileUploadUrlResult.getUrl(), param.getBytes(), hashMap);
            UploadAuthFileModel uploadAuthFileModel = (UploadAuthFileModel)this.vF().getContext().a(InterfaceKey.UPLOAD_AUTH_FILE);
            uploadAuthFileModel.setFileId(fileUploadUrlResult.getFileKey());
            uploadAuthFileModel.setAuthId(param.getAuthId());
            JsonObject jsonObject = HiddenOperationDelegator.request(this.vF(), uploadAuthFileModel);
            return JsonHelper.fromJson(jsonObject, Result.class);
        }
        catch (SuperException superException) {
            log.warn("uploadLegalAuthFile fail msg: {}", (Object)superException.getMessage());
            return ResultUtil.failed(superException, Result.class);
        }
        catch (Exception exception) {
            log.warn("uploadLegalAuthFile Exception msg: {}", (Object)exception.getMessage());
            return ResultUtil.failed(ErrorException.AUTH_FILE_UPLOAD_ERROR.e(exception.getMessage()), Result.class);
        }
    }

    @Override
    public AuthEffectiveInfoResult queryEffectiveAuthInfo(AuthEffectiveInfoParam param) {
        try {
            param.check();
            QueryAuthEffectiveInfoModel queryAuthEffectiveInfoModel = (QueryAuthEffectiveInfoModel)this.vF().getContext().a(InterfaceKey.QUERY_AUTH_EFFECTIVE_INFO);
            queryAuthEffectiveInfoModel.setOrganizeIdNo(param.getOrganizeIdNo());
            queryAuthEffectiveInfoModel.setOrganizeIdNoType(param.getOrganizeIdNoType().val());
            if (param.getAuthorizerType() == AuthorizerTypeEnum.LEGAL_AUTH.getType()) {
                queryAuthEffectiveInfoModel.setLegalIdNo(param.getLegalIdNo());
                queryAuthEffectiveInfoModel.setLegalIdNoType(param.getLegalIdNoType().type());
            }
            if (param.getAuthType() == AuthTypeEnum.AUTH_TO_PERSON.getType()) {
                queryAuthEffectiveInfoModel.setPersonId(param.getPersonId());
            }
            queryAuthEffectiveInfoModel.setAuthType(param.getAuthType());
            queryAuthEffectiveInfoModel.setAuthorizerType(param.getAuthorizerType());
            JsonObject jsonObject = HiddenOperationDelegator.request(this.vF(), queryAuthEffectiveInfoModel);
            return JsonHelper.fromJson(jsonObject, AuthEffectiveInfoResult.class);
        }
        catch (SuperException superException) {
            log.warn("queryEffectiveAuthInfo fail msg: {}", (Object)superException.getMessage());
            return ResultUtil.failed(superException, AuthEffectiveInfoResult.class);
        }
        catch (Exception exception) {
            log.warn("queryEffectiveAuthInfo Exception msg: {}", (Object)exception.getMessage());
            return ResultUtil.failed(ErrorException.QUERY_EFFECTIVE_AUTH_INFO_ERROR.e(exception.getMessage()), AuthEffectiveInfoResult.class);
        }
    }
}

