/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.util;

import com.timevale.esign.paas.esign.utils.StringUtil;
import com.timevale.esign.paas.esign.utils.exception.ErrorsDiscriptor;
import com.timevale.esign.paas.esign.utils.exception.SuperException;
import com.timevale.esign.paas.tech.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileRWUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileRWUtil.class);

    public static byte[] getContentFromFileDirectly(File file) throws SuperException {
        FileChannel fileChannel = null;
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            fileChannel = randomAccessFile.getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)fileChannel.size());
            fileChannel.read(byteBuffer);
            byteBuffer.flip();
            byte[] byArray = byteBuffer.array();
            byteBuffer.clear();
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (IOException iOException) {
            LOGGER.error("getContentFromFileDirectly exception. ", (Throwable)iOException);
            throw ErrorsDiscriptor.PDF_TempFileReadFailed.e(file.getPath());
        }
        finally {
            try {
                if (null != randomAccessFile) {
                    randomAccessFile.close();
                }
            }
            catch (IOException iOException) {
                LOGGER.error("close file input stream failed", (Throwable)iOException);
            }
            try {
                if (null != fileChannel) {
                    fileChannel.close();
                }
            }
            catch (IOException iOException) {
                LOGGER.error("close file channel failed", (Throwable)iOException);
            }
        }
    }

    public static void deleteTmpFile(File temporaryFile) {
        if (null != temporaryFile) {
            temporaryFile.delete();
        }
    }

    public static void deleteTmpFile(String tempFilePath) {
        if (!StringUtil.isNull(tempFilePath)) {
            File file = new File(tempFilePath);
            FileRWUtil.deleteTmpFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(File file) throws IOException {
        try (FileInputStream fileInputStream = null;){
            fileInputStream = new FileInputStream(file);
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)file.length());
            fileInputStream.getChannel().read(byteBuffer);
            byte[] byArray = byteBuffer.array();
            return byArray;
        }
    }

    public static void writeFile(File file, byte[] bytes) throws IOException {
        try (FileOutputStream fileOutputStream = null;){
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.getChannel().write(ByteBuffer.wrap(bytes));
        }
    }

    public static File createFileIfNotExist(String fileName) throws SuperException {
        boolean bl2;
        File file = new File(fileName);
        boolean bl3 = fileName.endsWith(File.separator) || file.isDirectory();
        boolean bl4 = bl2 = bl3 && file.exists() || !bl3 && file.getParentFile().exists();
        if (!bl2) {
            throw ErrorsDiscriptor.DIRECTORY_NOT_EXIST.e();
        }
        try {
            File file2 = file = !bl3 ? file : FileUtil.createTempFile("com.timevale.esign.paas.esign", ".pdf", file);
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (IOException iOException) {
            throw ErrorsDiscriptor.DST_FILE_CREATE_FAILED.e();
        }
        return file;
    }
}

