/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.util;

import com.timevale.esign.paas.esign.utils.StringUtil;
import com.timevale.esign.paas.esign.utils.exception.ErrorsDiscriptor;
import com.timevale.esign.paas.esign.utils.exception.SuperException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeFormatUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeFormatUtil.class);
    private static final String DEAULT_DATE_TIME_FORMATE = "yyyy-MM-dd HH:mm:ss";

    public static Date parseDateTime(String dateTime) throws SuperException {
        return TimeFormatUtil.parseDateTime(dateTime, DEAULT_DATE_TIME_FORMATE);
    }

    public static Date parseDateTime(String dateTime, String format) throws SuperException {
        Date date = null;
        if (StringUtil.isNull(dateTime)) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DEAULT_DATE_TIME_FORMATE);
            simpleDateFormat.setLenient(false);
            date = simpleDateFormat.parse(dateTime);
        }
        catch (ParseException parseException) {
            LOGGER.warn("parse date time failed. Value: " + dateTime);
            throw ErrorsDiscriptor.InvalidParameter.e();
        }
        return date;
    }

    public static String dateTimeToString(Date date) {
        return TimeFormatUtil.dateTimeToString(date, DEAULT_DATE_TIME_FORMATE);
    }

    public static String dateTimeToString(Date date, String dateTimeFormate) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateTimeFormate);
        return simpleDateFormat.format(date);
    }
}

