/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tgtext.bouncycastle.cert.crmf;

import com.timevale.esign.paas.tgtext.bouncycastle.asn1.crmf.EncryptedValue;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.x509.Certificate;
import com.timevale.esign.paas.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.esign.paas.tgtext.bouncycastle.cert.crmf.CRMFException;
import com.timevale.esign.paas.tgtext.bouncycastle.cert.crmf.EncryptedValuePadder;
import com.timevale.esign.paas.tgtext.bouncycastle.cert.crmf.ValueDecryptorGenerator;
import com.timevale.esign.paas.tgtext.bouncycastle.operator.InputDecryptor;
import com.timevale.esign.paas.tgtext.bouncycastle.util.Strings;
import com.timevale.esign.paas.tgtext.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class EncryptedValueParser {
    private EncryptedValue value;
    private EncryptedValuePadder padder;

    public EncryptedValueParser(EncryptedValue encryptedValue) {
        this.value = encryptedValue;
    }

    public EncryptedValueParser(EncryptedValue encryptedValue, EncryptedValuePadder encryptedValuePadder) {
        this.value = encryptedValue;
        this.padder = encryptedValuePadder;
    }

    private byte[] decryptValue(ValueDecryptorGenerator valueDecryptorGenerator) throws CRMFException {
        if (this.value.getIntendedAlg() != null) {
            throw new UnsupportedOperationException();
        }
        if (this.value.getValueHint() != null) {
            throw new UnsupportedOperationException();
        }
        InputDecryptor inputDecryptor = valueDecryptorGenerator.getValueDecryptor(this.value.getKeyAlg(), this.value.getSymmAlg(), this.value.getEncSymmKey().getBytes());
        InputStream inputStream = inputDecryptor.getInputStream(new ByteArrayInputStream(this.value.getEncValue().getBytes()));
        try {
            byte[] byArray = Streams.readAll(inputStream);
            if (this.padder != null) {
                return this.padder.getUnpaddedData(byArray);
            }
            return byArray;
        }
        catch (IOException iOException) {
            throw new CRMFException("Cannot parse decrypted data: " + iOException.getMessage(), iOException);
        }
    }

    public X509CertificateHolder readCertificateHolder(ValueDecryptorGenerator valueDecryptorGenerator) throws CRMFException {
        return new X509CertificateHolder(Certificate.getInstance(this.decryptValue(valueDecryptorGenerator)));
    }

    public char[] readPassphrase(ValueDecryptorGenerator valueDecryptorGenerator) throws CRMFException {
        return Strings.fromUTF8ByteArray(this.decryptValue(valueDecryptorGenerator)).toCharArray();
    }
}

