/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tgtext.bouncycastle.cert.crmf;

import com.timevale.esign.paas.tgtext.bouncycastle.asn1.DERBitString;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.crmf.CertRequest;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.crmf.PKMACValue;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.crmf.POPOSigningKey;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.crmf.POPOSigningKeyInput;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.x509.GeneralName;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.timevale.esign.paas.tgtext.bouncycastle.cert.crmf.CRMFException;
import com.timevale.esign.paas.tgtext.bouncycastle.cert.crmf.CRMFUtil;
import com.timevale.esign.paas.tgtext.bouncycastle.cert.crmf.PKMACValueGenerator;
import com.timevale.esign.paas.tgtext.bouncycastle.operator.ContentSigner;

public class ProofOfPossessionSigningKeyBuilder {
    private CertRequest certRequest;
    private SubjectPublicKeyInfo pubKeyInfo;
    private GeneralName name;
    private PKMACValue publicKeyMAC;

    public ProofOfPossessionSigningKeyBuilder(CertRequest certRequest) {
        this.certRequest = certRequest;
    }

    public ProofOfPossessionSigningKeyBuilder(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.pubKeyInfo = subjectPublicKeyInfo;
    }

    public ProofOfPossessionSigningKeyBuilder setSender(GeneralName generalName) {
        this.name = generalName;
        return this;
    }

    public ProofOfPossessionSigningKeyBuilder setPublicKeyMac(PKMACValueGenerator pKMACValueGenerator, char[] cArray) throws CRMFException {
        this.publicKeyMAC = pKMACValueGenerator.generate(cArray, this.pubKeyInfo);
        return this;
    }

    public POPOSigningKey build(ContentSigner contentSigner) {
        POPOSigningKeyInput pOPOSigningKeyInput;
        if (this.name != null && this.publicKeyMAC != null) {
            throw new IllegalStateException("name and publicKeyMAC cannot both be set.");
        }
        if (this.certRequest != null) {
            pOPOSigningKeyInput = null;
            CRMFUtil.derEncodeToStream(this.certRequest, contentSigner.getOutputStream());
        } else if (this.name != null) {
            pOPOSigningKeyInput = new POPOSigningKeyInput(this.name, this.pubKeyInfo);
            CRMFUtil.derEncodeToStream(pOPOSigningKeyInput, contentSigner.getOutputStream());
        } else {
            pOPOSigningKeyInput = new POPOSigningKeyInput(this.publicKeyMAC, this.pubKeyInfo);
            CRMFUtil.derEncodeToStream(pOPOSigningKeyInput, contentSigner.getOutputStream());
        }
        return new POPOSigningKey(pOPOSigningKeyInput, contentSigner.getAlgorithmIdentifier(), new DERBitString(contentSigner.getSignature()));
    }
}

