/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tgtext.bouncycastle.cert.crmf.jcajce;

import com.timevale.esign.paas.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.esign.paas.tgtext.bouncycastle.cert.crmf.CRMFException;
import com.timevale.esign.paas.tgtext.bouncycastle.cert.crmf.ValueDecryptorGenerator;
import com.timevale.esign.paas.tgtext.bouncycastle.cert.crmf.jcajce.CRMFHelper;
import com.timevale.esign.paas.tgtext.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import com.timevale.esign.paas.tgtext.bouncycastle.jcajce.util.NamedJcaJceHelper;
import com.timevale.esign.paas.tgtext.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import com.timevale.esign.paas.tgtext.bouncycastle.operator.InputDecryptor;
import com.timevale.esign.paas.tgtext.bouncycastle.operator.OperatorException;
import com.timevale.esign.paas.tgtext.bouncycastle.operator.jcajce.JceAsymmetricKeyUnwrapper;
import java.io.InputStream;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.SecretKeySpec;

public class JceAsymmetricValueDecryptorGenerator
implements ValueDecryptorGenerator {
    private PrivateKey recipientKey;
    private CRMFHelper helper = new CRMFHelper(new DefaultJcaJceHelper());
    private Provider provider = null;
    private String providerName = null;

    public JceAsymmetricValueDecryptorGenerator(PrivateKey privateKey) {
        this.recipientKey = privateKey;
    }

    public JceAsymmetricValueDecryptorGenerator setProvider(Provider provider) {
        this.helper = new CRMFHelper(new ProviderJcaJceHelper(provider));
        this.provider = provider;
        this.providerName = null;
        return this;
    }

    public JceAsymmetricValueDecryptorGenerator setProvider(String string) {
        this.helper = new CRMFHelper(new NamedJcaJceHelper(string));
        this.provider = null;
        this.providerName = string;
        return this;
    }

    private Key extractSecretKey(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, byte[] byArray) throws CRMFException {
        try {
            JceAsymmetricKeyUnwrapper jceAsymmetricKeyUnwrapper = new JceAsymmetricKeyUnwrapper(algorithmIdentifier, this.recipientKey);
            if (this.provider != null) {
                jceAsymmetricKeyUnwrapper.setProvider(this.provider);
            }
            if (this.providerName != null) {
                jceAsymmetricKeyUnwrapper.setProvider(this.providerName);
            }
            return new SecretKeySpec((byte[])jceAsymmetricKeyUnwrapper.generateUnwrappedKey(algorithmIdentifier2, byArray).getRepresentation(), algorithmIdentifier2.getAlgorithm().getId());
        }
        catch (OperatorException operatorException) {
            throw new CRMFException("key invalid in message: " + operatorException.getMessage(), operatorException);
        }
    }

    @Override
    public InputDecryptor getValueDecryptor(AlgorithmIdentifier algorithmIdentifier, final AlgorithmIdentifier algorithmIdentifier2, byte[] byArray) throws CRMFException {
        Key key = this.extractSecretKey(algorithmIdentifier, algorithmIdentifier2, byArray);
        final Cipher cipher = this.helper.createContentCipher(key, algorithmIdentifier2);
        return new InputDecryptor(){

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return algorithmIdentifier2;
            }

            @Override
            public InputStream getInputStream(InputStream inputStream) {
                return new CipherInputStream(inputStream, cipher);
            }
        };
    }
}

