/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tgtext.bouncycastle.cert.jcajce;

import com.timevale.esign.paas.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.timevale.esign.paas.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.esign.paas.tgtext.bouncycastle.cert.X509ContentVerifierProviderBuilder;
import com.timevale.esign.paas.tgtext.bouncycastle.operator.ContentVerifierProvider;
import com.timevale.esign.paas.tgtext.bouncycastle.operator.OperatorCreationException;
import com.timevale.esign.paas.tgtext.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import java.security.Provider;
import java.security.cert.CertificateException;

public class JcaX509ContentVerifierProviderBuilder
implements X509ContentVerifierProviderBuilder {
    private JcaContentVerifierProviderBuilder builder = new JcaContentVerifierProviderBuilder();

    public JcaX509ContentVerifierProviderBuilder setProvider(Provider provider) {
        this.builder.setProvider(provider);
        return this;
    }

    public JcaX509ContentVerifierProviderBuilder setProvider(String string) {
        this.builder.setProvider(string);
        return this;
    }

    @Override
    public ContentVerifierProvider build(SubjectPublicKeyInfo subjectPublicKeyInfo) throws OperatorCreationException {
        return this.builder.build(subjectPublicKeyInfo);
    }

    @Override
    public ContentVerifierProvider build(X509CertificateHolder x509CertificateHolder) throws OperatorCreationException {
        try {
            return this.builder.build(x509CertificateHolder);
        }
        catch (CertificateException certificateException) {
            throw new OperatorCreationException("Unable to process certificate: " + certificateException.getMessage(), certificateException);
        }
    }
}

