/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tgtext.bouncycastle.crypto.agreement;

import com.timevale.esign.paas.tgtext.bouncycastle.crypto.BasicAgreement;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.params.DHParameters;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.params.DHPrivateKeyParameters;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.params.DHPublicKeyParameters;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.params.ParametersWithRandom;
import java.math.BigInteger;

public class DHBasicAgreement
implements BasicAgreement {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private DHPrivateKeyParameters key;
    private DHParameters dhParams;

    @Override
    public void init(CipherParameters cipherParameters) {
        AsymmetricKeyParameter asymmetricKeyParameter;
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            asymmetricKeyParameter = (AsymmetricKeyParameter)parametersWithRandom.getParameters();
        } else {
            asymmetricKeyParameter = (AsymmetricKeyParameter)cipherParameters;
        }
        if (!(asymmetricKeyParameter instanceof DHPrivateKeyParameters)) {
            throw new IllegalArgumentException("DHEngine expects DHPrivateKeyParameters");
        }
        this.key = (DHPrivateKeyParameters)asymmetricKeyParameter;
        this.dhParams = this.key.getParameters();
    }

    @Override
    public int getFieldSize() {
        return (this.key.getParameters().getP().bitLength() + 7) / 8;
    }

    @Override
    public BigInteger calculateAgreement(CipherParameters cipherParameters) {
        DHPublicKeyParameters dHPublicKeyParameters = (DHPublicKeyParameters)cipherParameters;
        if (!dHPublicKeyParameters.getParameters().equals(this.dhParams)) {
            throw new IllegalArgumentException("Diffie-Hellman public key has wrong parameters.");
        }
        BigInteger bigInteger = this.dhParams.getP();
        BigInteger bigInteger2 = dHPublicKeyParameters.getY();
        if (bigInteger2 == null || bigInteger2.compareTo(ONE) <= 0 || bigInteger2.compareTo(bigInteger.subtract(ONE)) >= 0) {
            throw new IllegalArgumentException("Diffie-Hellman public key is weak");
        }
        BigInteger bigInteger3 = bigInteger2.modPow(this.key.getX(), bigInteger);
        if (bigInteger3.equals(ONE)) {
            throw new IllegalStateException("Shared key can't be 1");
        }
        return bigInteger3;
    }
}

