/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tgtext.bouncycastle.crypto.macs;

import com.timevale.esign.paas.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.DataLengthException;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.InvalidCipherTextException;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.Mac;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.modes.GCMBlockCipher;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.params.AEADParameters;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.params.KeyParameter;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.params.ParametersWithIV;

public class GMac
implements Mac {
    private final GCMBlockCipher cipher;
    private final int macSizeBits;

    public GMac(GCMBlockCipher gCMBlockCipher) {
        this.cipher = gCMBlockCipher;
        this.macSizeBits = 128;
    }

    public GMac(GCMBlockCipher gCMBlockCipher, int n2) {
        this.cipher = gCMBlockCipher;
        this.macSizeBits = n2;
    }

    @Override
    public void init(CipherParameters cipherParameters) throws IllegalArgumentException {
        if (!(cipherParameters instanceof ParametersWithIV)) {
            throw new IllegalArgumentException("GMAC requires ParametersWithIV");
        }
        ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
        byte[] byArray = parametersWithIV.getIV();
        KeyParameter keyParameter = (KeyParameter)parametersWithIV.getParameters();
        this.cipher.init(true, new AEADParameters(keyParameter, this.macSizeBits, byArray));
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getUnderlyingCipher().getAlgorithmName() + "-GMAC";
    }

    @Override
    public int getMacSize() {
        return this.macSizeBits / 8;
    }

    @Override
    public void update(byte by2) throws IllegalStateException {
        this.cipher.processAADByte(by2);
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) throws DataLengthException, IllegalStateException {
        this.cipher.processAADBytes(byArray, n2, n3);
    }

    @Override
    public int doFinal(byte[] byArray, int n2) throws DataLengthException, IllegalStateException {
        try {
            return this.cipher.doFinal(byArray, n2);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new IllegalStateException(invalidCipherTextException.toString());
        }
    }

    @Override
    public void reset() {
        this.cipher.reset();
    }
}

