/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tgtext.bouncycastle.crypto.signers;

import com.timevale.esign.paas.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.DSA;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.Digest;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.Signer;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.params.ParametersWithRandom;
import java.io.IOException;
import java.math.BigInteger;

public class DSADigestSigner
implements Signer {
    private final Digest digest;
    private final DSA dsaSigner;
    private boolean forSigning;

    public DSADigestSigner(DSA dSA, Digest digest) {
        this.digest = digest;
        this.dsaSigner = dSA;
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        this.forSigning = bl2;
        AsymmetricKeyParameter asymmetricKeyParameter = cipherParameters instanceof ParametersWithRandom ? (AsymmetricKeyParameter)((ParametersWithRandom)cipherParameters).getParameters() : (AsymmetricKeyParameter)cipherParameters;
        if (bl2 && !asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("Signing Requires Private Key.");
        }
        if (!bl2 && asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("Verification Requires Public Key.");
        }
        this.reset();
        this.dsaSigner.init(bl2, cipherParameters);
    }

    @Override
    public void update(byte by2) {
        this.digest.update(by2);
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        this.digest.update(byArray, n2, n3);
    }

    @Override
    public byte[] generateSignature() {
        if (!this.forSigning) {
            throw new IllegalStateException("DSADigestSigner not initialised for signature generation.");
        }
        byte[] byArray = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray, 0);
        BigInteger[] bigIntegerArray = this.dsaSigner.generateSignature(byArray);
        try {
            return this.derEncode(bigIntegerArray[0], bigIntegerArray[1]);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to encode signature");
        }
    }

    @Override
    public boolean verifySignature(byte[] byArray) {
        if (this.forSigning) {
            throw new IllegalStateException("DSADigestSigner not initialised for verification");
        }
        byte[] byArray2 = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray2, 0);
        try {
            BigInteger[] bigIntegerArray = this.derDecode(byArray);
            return this.dsaSigner.verifySignature(byArray2, bigIntegerArray[0], bigIntegerArray[1]);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public void reset() {
        this.digest.reset();
    }

    private byte[] derEncode(BigInteger bigInteger, BigInteger bigInteger2) throws IOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(bigInteger));
        aSN1EncodableVector.add(new ASN1Integer(bigInteger2));
        return new DERSequence(aSN1EncodableVector).getEncoded("DER");
    }

    private BigInteger[] derDecode(byte[] byArray) throws IOException {
        ASN1Sequence aSN1Sequence = (ASN1Sequence)ASN1Primitive.fromByteArray(byArray);
        return new BigInteger[]{((ASN1Integer)aSN1Sequence.getObjectAt(0)).getValue(), ((ASN1Integer)aSN1Sequence.getObjectAt(1)).getValue()};
    }
}

