/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tgtext.bouncycastle.crypto.signers;

import com.timevale.esign.paas.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.DSA;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.params.DSAKeyParameters;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.params.DSAParameters;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.params.DSAPublicKeyParameters;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.params.ParametersWithRandom;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.signers.DSAKCalculator;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.signers.RandomDSAKCalculator;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DSASigner
implements DSA {
    private final DSAKCalculator kCalculator;
    private DSAKeyParameters key;
    private SecureRandom random;

    public DSASigner() {
        this.kCalculator = new RandomDSAKCalculator();
    }

    public DSASigner(DSAKCalculator dSAKCalculator) {
        this.kCalculator = dSAKCalculator;
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        SecureRandom secureRandom = null;
        if (bl2) {
            if (cipherParameters instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
                this.key = (DSAPrivateKeyParameters)parametersWithRandom.getParameters();
                secureRandom = parametersWithRandom.getRandom();
            } else {
                this.key = (DSAPrivateKeyParameters)cipherParameters;
            }
        } else {
            this.key = (DSAPublicKeyParameters)cipherParameters;
        }
        this.random = this.initSecureRandom(bl2 && !this.kCalculator.isDeterministic(), secureRandom);
    }

    @Override
    public BigInteger[] generateSignature(byte[] byArray) {
        DSAParameters dSAParameters = this.key.getParameters();
        BigInteger bigInteger = dSAParameters.getQ();
        BigInteger bigInteger2 = this.calculateE(bigInteger, byArray);
        BigInteger bigInteger3 = ((DSAPrivateKeyParameters)this.key).getX();
        if (this.kCalculator.isDeterministic()) {
            this.kCalculator.init(bigInteger, bigInteger3, byArray);
        } else {
            this.kCalculator.init(bigInteger, this.random);
        }
        BigInteger bigInteger4 = this.kCalculator.nextK();
        BigInteger bigInteger5 = dSAParameters.getG().modPow(bigInteger4.add(this.getRandomizer(bigInteger, this.random)), dSAParameters.getP()).mod(bigInteger);
        bigInteger4 = bigInteger4.modInverse(bigInteger).multiply(bigInteger2.add(bigInteger3.multiply(bigInteger5)));
        BigInteger bigInteger6 = bigInteger4.mod(bigInteger);
        return new BigInteger[]{bigInteger5, bigInteger6};
    }

    @Override
    public boolean verifySignature(byte[] byArray, BigInteger bigInteger, BigInteger bigInteger2) {
        DSAParameters dSAParameters = this.key.getParameters();
        BigInteger bigInteger3 = dSAParameters.getQ();
        BigInteger bigInteger4 = this.calculateE(bigInteger3, byArray);
        BigInteger bigInteger5 = BigInteger.valueOf(0L);
        if (bigInteger5.compareTo(bigInteger) >= 0 || bigInteger3.compareTo(bigInteger) <= 0) {
            return false;
        }
        if (bigInteger5.compareTo(bigInteger2) >= 0 || bigInteger3.compareTo(bigInteger2) <= 0) {
            return false;
        }
        BigInteger bigInteger6 = bigInteger2.modInverse(bigInteger3);
        BigInteger bigInteger7 = bigInteger4.multiply(bigInteger6).mod(bigInteger3);
        BigInteger bigInteger8 = bigInteger.multiply(bigInteger6).mod(bigInteger3);
        BigInteger bigInteger9 = dSAParameters.getP();
        bigInteger7 = dSAParameters.getG().modPow(bigInteger7, bigInteger9);
        bigInteger8 = ((DSAPublicKeyParameters)this.key).getY().modPow(bigInteger8, bigInteger9);
        BigInteger bigInteger10 = bigInteger7.multiply(bigInteger8).mod(bigInteger9).mod(bigInteger3);
        return bigInteger10.equals(bigInteger);
    }

    private BigInteger calculateE(BigInteger bigInteger, byte[] byArray) {
        if (bigInteger.bitLength() >= byArray.length * 8) {
            return new BigInteger(1, byArray);
        }
        byte[] byArray2 = new byte[bigInteger.bitLength() / 8];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        return new BigInteger(1, byArray2);
    }

    protected SecureRandom initSecureRandom(boolean bl2, SecureRandom secureRandom) {
        return !bl2 ? null : (secureRandom != null ? secureRandom : new SecureRandom());
    }

    private BigInteger getRandomizer(BigInteger bigInteger, SecureRandom secureRandom) {
        int n2 = 7;
        return new BigInteger(n2, secureRandom != null ? secureRandom : new SecureRandom()).add(BigInteger.valueOf(128L)).multiply(bigInteger);
    }
}

