/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tgtext.bouncycastle.crypto.tls;

import com.timevale.esign.paas.tgtext.bouncycastle.crypto.Digest;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.Signer;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.params.DHParameters;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.tls.DigestInputBuffer;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.tls.DigitallySigned;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.tls.SecurityParameters;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.tls.ServerDHParams;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.tls.SignerInputBuffer;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.tls.TlsCredentials;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.tls.TlsDHKeyExchange;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.tls.TlsDHUtils;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.tls.TlsFatalAlert;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.tls.TlsSigner;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.tls.TlsSignerCredentials;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.tls.TlsUtils;
import com.timevale.esign.paas.tgtext.bouncycastle.util.io.TeeInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class TlsDHEKeyExchange
extends TlsDHKeyExchange {
    protected TlsSignerCredentials serverCredentials = null;

    public TlsDHEKeyExchange(int n2, Vector vector, DHParameters dHParameters) {
        super(n2, vector, dHParameters);
    }

    @Override
    public void processServerCredentials(TlsCredentials tlsCredentials) throws IOException {
        if (!(tlsCredentials instanceof TlsSignerCredentials)) {
            throw new TlsFatalAlert(80);
        }
        this.processServerCertificate(tlsCredentials.getCertificate());
        this.serverCredentials = (TlsSignerCredentials)tlsCredentials;
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        if (this.dhParameters == null) {
            throw new TlsFatalAlert(80);
        }
        DigestInputBuffer digestInputBuffer = new DigestInputBuffer();
        this.dhAgreePrivateKey = TlsDHUtils.generateEphemeralServerKeyExchange(this.context.getSecureRandom(), this.dhParameters, digestInputBuffer);
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = TlsUtils.getSignatureAndHashAlgorithm(this.context, this.serverCredentials);
        Digest digest = TlsUtils.createHash(signatureAndHashAlgorithm);
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        digest.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        digest.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        digestInputBuffer.updateDigest(digest);
        byte[] byArray = new byte[digest.getDigestSize()];
        digest.doFinal(byArray, 0);
        byte[] byArray2 = this.serverCredentials.generateCertificateSignature(byArray);
        DigitallySigned digitallySigned = new DigitallySigned(signatureAndHashAlgorithm, byArray2);
        digitallySigned.encode(digestInputBuffer);
        return digestInputBuffer.toByteArray();
    }

    @Override
    public void processServerKeyExchange(InputStream inputStream) throws IOException {
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        SignerInputBuffer signerInputBuffer = new SignerInputBuffer();
        TeeInputStream teeInputStream = new TeeInputStream(inputStream, signerInputBuffer);
        ServerDHParams serverDHParams = ServerDHParams.parse(teeInputStream);
        DigitallySigned digitallySigned = this.parseSignature(inputStream);
        Signer signer = this.initVerifyer(this.tlsSigner, digitallySigned.getAlgorithm(), securityParameters);
        signerInputBuffer.updateSigner(signer);
        if (!signer.verifySignature(digitallySigned.getSignature())) {
            throw new TlsFatalAlert(51);
        }
        this.dhAgreePublicKey = TlsDHUtils.validateDHPublicKey(serverDHParams.getPublicKey());
        this.dhParameters = this.validateDHParameters(this.dhAgreePublicKey.getParameters());
    }

    protected Signer initVerifyer(TlsSigner tlsSigner, SignatureAndHashAlgorithm signatureAndHashAlgorithm, SecurityParameters securityParameters) {
        Signer signer = tlsSigner.createVerifyer(signatureAndHashAlgorithm, this.serverPublicKey);
        signer.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        signer.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        return signer;
    }
}

