/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tgtext.bouncycastle.jcajce.provider.symmetric;

import com.timevale.esign.paas.tgtext.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.PasswordConverter;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.generators.SCrypt;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.params.KeyParameter;
import com.timevale.esign.paas.tgtext.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.timevale.esign.paas.tgtext.bouncycastle.jcajce.provider.symmetric.util.BCPBEKey;
import com.timevale.esign.paas.tgtext.bouncycastle.jcajce.provider.symmetric.util.BaseSecretKeyFactory;
import com.timevale.esign.paas.tgtext.bouncycastle.jcajce.provider.util.AlgorithmProvider;
import com.timevale.esign.paas.tgtext.bouncycastle.jcajce.spec.ScryptKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;

public class SCRYPT {
    private SCRYPT() {
    }

    public static class BasePBKDF2
    extends BaseSecretKeyFactory {
        private int scheme;

        public BasePBKDF2(String string, int n2) {
            super(string, MiscObjectIdentifiers.id_scrypt);
            this.scheme = n2;
        }

        @Override
        protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof ScryptKeySpec) {
                ScryptKeySpec scryptKeySpec = (ScryptKeySpec)keySpec;
                if (scryptKeySpec.getSalt() == null) {
                    throw new IllegalArgumentException("Salt S must be provided.");
                }
                if (scryptKeySpec.getCostParameter() <= 1) {
                    throw new IllegalArgumentException("Cost parameter N must be > 1.");
                }
                if (scryptKeySpec.getKeyLength() <= 0) {
                    throw new InvalidKeySpecException("positive key length required: " + scryptKeySpec.getKeyLength());
                }
                if (scryptKeySpec.getPassword().length == 0) {
                    throw new IllegalArgumentException("password empty");
                }
                KeyParameter keyParameter = new KeyParameter(SCrypt.generate(PasswordConverter.UTF8.convert(scryptKeySpec.getPassword()), scryptKeySpec.getSalt(), scryptKeySpec.getCostParameter(), scryptKeySpec.getBlockSize(), scryptKeySpec.getParallelizationParameter(), scryptKeySpec.getKeyLength() / 8));
                return new BCPBEKey(this.algName, scryptKeySpec, keyParameter);
            }
            throw new InvalidKeySpecException("Invalid KeySpec");
        }
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = SCRYPT.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("SecretKeyFactory.SCRYPT", PREFIX + "$ScryptWithUTF8");
            configurableProvider.addAlgorithm("SecretKeyFactory", MiscObjectIdentifiers.id_scrypt, PREFIX + "$ScryptWithUTF8");
        }
    }

    public static class ScryptWithUTF8
    extends BasePBKDF2 {
        public ScryptWithUTF8() {
            super("SCRYPT", 5);
        }
    }
}

