/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tgtext.bouncycastle.math.ec.custom.sec;

import com.timevale.esign.paas.tgtext.bouncycastle.math.ec.ECCurve;
import com.timevale.esign.paas.tgtext.bouncycastle.math.ec.ECFieldElement;
import com.timevale.esign.paas.tgtext.bouncycastle.math.ec.ECLookupTable;
import com.timevale.esign.paas.tgtext.bouncycastle.math.ec.ECPoint;
import com.timevale.esign.paas.tgtext.bouncycastle.math.ec.custom.sec.SecT571FieldElement;
import com.timevale.esign.paas.tgtext.bouncycastle.math.ec.custom.sec.SecT571R1Point;
import com.timevale.esign.paas.tgtext.bouncycastle.math.raw.Nat576;
import com.timevale.esign.paas.tgtext.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecT571R1Curve
extends ECCurve.AbstractF2m {
    private static final int SecT571R1_DEFAULT_COORDS = 6;
    protected SecT571R1Point infinity = new SecT571R1Point(this, null, null);
    static final SecT571FieldElement SecT571R1_B = new SecT571FieldElement(new BigInteger(1, Hex.decode("02F40E7E2221F295DE297117B7F3D62F5C6A97FFCB8CEFF1CD6BA8CE4A9A18AD84FFABBD8EFA59332BE7AD6756A66E294AFD185A78FF12AA520E4DE739BACA0C7FFEFF7F2955727A")));
    static final SecT571FieldElement SecT571R1_B_SQRT = (SecT571FieldElement)SecT571R1_B.sqrt();

    public SecT571R1Curve() {
        super(571, 2, 5, 10);
        this.a = this.fromBigInteger(BigInteger.valueOf(1L));
        this.b = SecT571R1_B;
        this.order = new BigInteger(1, Hex.decode("03FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE661CE18FF55987308059B186823851EC7DD9CA1161DE93D5174D66E8382E9BB2FE84E47"));
        this.cofactor = BigInteger.valueOf(2L);
        this.coord = 6;
    }

    @Override
    protected ECCurve cloneCurve() {
        return new SecT571R1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n2) {
        switch (n2) {
            case 6: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getFieldSize() {
        return 571;
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecT571FieldElement(bigInteger);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl2) {
        return new SecT571R1Point((ECCurve)this, eCFieldElement, eCFieldElement2, bl2);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray, boolean bl2) {
        return new SecT571R1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray, bl2);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public boolean isKoblitz() {
        return false;
    }

    public int getM() {
        return 571;
    }

    public boolean isTrinomial() {
        return false;
    }

    public int getK1() {
        return 2;
    }

    public int getK2() {
        return 5;
    }

    public int getK3() {
        return 10;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n2, final int n3) {
        final long[] lArray = new long[n3 * 9 * 2];
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            ECPoint eCPoint = eCPointArray[n2 + i2];
            Nat576.copy64(((SecT571FieldElement)eCPoint.getRawXCoord()).x, 0, lArray, n4);
            Nat576.copy64(((SecT571FieldElement)eCPoint.getRawYCoord()).x, 0, lArray, n4 += 9);
            n4 += 9;
        }
        return new ECLookupTable(){

            @Override
            public int getSize() {
                return n3;
            }

            @Override
            public ECPoint lookup(int n2) {
                long[] lArray3 = Nat576.create64();
                long[] lArray2 = Nat576.create64();
                int n32 = 0;
                for (int i2 = 0; i2 < n3; ++i2) {
                    long l2 = (i2 ^ n2) - 1 >> 31;
                    for (int i3 = 0; i3 < 9; ++i3) {
                        int n4 = i3;
                        lArray3[n4] = lArray3[n4] ^ lArray[n32 + i3] & l2;
                        int n5 = i3;
                        lArray2[n5] = lArray2[n5] ^ lArray[n32 + 9 + i3] & l2;
                    }
                    n32 += 18;
                }
                return SecT571R1Curve.this.createRawPoint(new SecT571FieldElement(lArray3), new SecT571FieldElement(lArray2), false);
            }
        };
    }
}

