/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tgtext.bouncycastle.operator.bc;

import com.timevale.esign.paas.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.Digest;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.ExtendedDigest;
import com.timevale.esign.paas.tgtext.bouncycastle.operator.DigestCalculator;
import com.timevale.esign.paas.tgtext.bouncycastle.operator.DigestCalculatorProvider;
import com.timevale.esign.paas.tgtext.bouncycastle.operator.OperatorCreationException;
import com.timevale.esign.paas.tgtext.bouncycastle.operator.bc.BcDefaultDigestProvider;
import com.timevale.esign.paas.tgtext.bouncycastle.operator.bc.BcDigestProvider;
import java.io.IOException;
import java.io.OutputStream;

public class BcDigestCalculatorProvider
implements DigestCalculatorProvider {
    private BcDigestProvider digestProvider = BcDefaultDigestProvider.INSTANCE;

    @Override
    public DigestCalculator get(final AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        ExtendedDigest extendedDigest = this.digestProvider.get(algorithmIdentifier);
        final DigestOutputStream digestOutputStream = new DigestOutputStream(extendedDigest);
        return new DigestCalculator(){

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return algorithmIdentifier;
            }

            @Override
            public OutputStream getOutputStream() {
                return digestOutputStream;
            }

            @Override
            public byte[] getDigest() {
                return digestOutputStream.getDigest();
            }
        };
    }

    private class DigestOutputStream
    extends OutputStream {
        private Digest dig;

        DigestOutputStream(Digest digest) {
            this.dig = digest;
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) throws IOException {
            this.dig.update(byArray, n2, n3);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.dig.update(byArray, 0, byArray.length);
        }

        @Override
        public void write(int n2) throws IOException {
            this.dig.update((byte)n2);
        }

        byte[] getDigest() {
            byte[] byArray = new byte[this.dig.getDigestSize()];
            this.dig.doFinal(byArray, 0);
            return byArray;
        }
    }
}

