/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tgtext.text;

import com.timevale.esign.paas.tgtext.text.e;
import com.timevale.esign.paas.tgtext.text.l;
import com.timevale.esign.paas.tgtext.text.m;
import com.timevale.esign.paas.tgtext.text.pdf.p;

public class Font
implements Comparable<Font> {
    public static final int afp = 0;
    public static final int afq = 1;
    public static final int afr = 2;
    public static final int afs = 4;
    public static final int aft = 8;
    public static final int afu = 3;
    public static final int afv = -1;
    public static final int afw = 12;
    private FontFamily afx = FontFamily.UNDEFINED;
    private float afy = -1.0f;
    private int afz = -1;
    private e WU = null;
    private p Zy = null;

    public Font(Font other) {
        this.afx = other.afx;
        this.afy = other.afy;
        this.afz = other.afz;
        this.WU = other.WU;
        this.Zy = other.Zy;
    }

    public Font(FontFamily family, float size, int style, e color) {
        this.afx = family;
        this.afy = size;
        this.afz = style;
        this.WU = color;
    }

    public Font(p bf2, float size, int style, e color) {
        this.Zy = bf2;
        this.afy = size;
        this.afz = style;
        this.WU = color;
    }

    public Font(p bf2, float size, int style) {
        this(bf2, size, style, null);
    }

    public Font(p bf2, float size) {
        this(bf2, size, -1, null);
    }

    public Font(p bf2) {
        this(bf2, -1.0f, -1, null);
    }

    public Font(FontFamily family, float size, int style) {
        this(family, size, style, null);
    }

    public Font(FontFamily family, float size) {
        this(family, size, -1, null);
    }

    public Font(FontFamily family) {
        this(family, -1.0f, -1, null);
    }

    public Font() {
        this(FontFamily.UNDEFINED, -1.0f, -1, null);
    }

    public int c(Font font) {
        if (font == null) {
            return -1;
        }
        try {
            if (this.Zy != null && !this.Zy.equals(font.AE())) {
                return -2;
            }
            if (this.afx != font.Au()) {
                return 1;
            }
            if (this.afy != font.Aw()) {
                return 2;
            }
            if (this.afz != font.Ay()) {
                return 3;
            }
            if (this.WU == null) {
                if (font.WU == null) {
                    return 0;
                }
                return 4;
            }
            if (font.WU == null) {
                return 4;
            }
            if (this.WU.equals(font.ws())) {
                return 0;
            }
            return 4;
        }
        catch (ClassCastException classCastException) {
            return -3;
        }
    }

    public FontFamily Au() {
        return this.afx;
    }

    public String Av() {
        String string = "unknown";
        switch (this.Au()) {
            case COURIER: {
                return "Courier";
            }
            case HELVETICA: {
                return "Helvetica";
            }
            case TIMES_ROMAN: {
                return "Times-Roman";
            }
            case SYMBOL: {
                return "Symbol";
            }
            case ZAPFDINGBATS: {
                return "ZapfDingbats";
            }
        }
        if (this.Zy != null) {
            String[][] stringArray;
            for (String[] stringArray2 : stringArray = this.Zy.Fk()) {
                if ("0".equals(stringArray2[2])) {
                    return stringArray2[3];
                }
                if ("1033".equals(stringArray2[2])) {
                    string = stringArray2[3];
                }
                if (!"".equals(stringArray2[2])) continue;
                string = stringArray2[3];
            }
        }
        return string;
    }

    public void eD(String string) {
        this.afx = Font.eE(string);
    }

    public static FontFamily eE(String string) {
        if (string.equalsIgnoreCase("Courier")) {
            return FontFamily.COURIER;
        }
        if (string.equalsIgnoreCase("Helvetica")) {
            return FontFamily.HELVETICA;
        }
        if (string.equalsIgnoreCase("Times-Roman")) {
            return FontFamily.TIMES_ROMAN;
        }
        if (string.equalsIgnoreCase("Symbol")) {
            return FontFamily.SYMBOL;
        }
        if (string.equalsIgnoreCase("ZapfDingbats")) {
            return FontFamily.ZAPFDINGBATS;
        }
        return FontFamily.UNDEFINED;
    }

    public float Aw() {
        return this.afy;
    }

    public float Ax() {
        float f2 = this.afy;
        if (f2 == -1.0f) {
            f2 = 12.0f;
        }
        return f2;
    }

    public float C(float f2) {
        return f2 * this.Ax();
    }

    public void D(float f2) {
        this.afy = f2;
    }

    public int Ay() {
        return this.afz;
    }

    public int Az() {
        int n2 = this.afz;
        if (n2 == -1) {
            n2 = 0;
        }
        if (this.Zy != null) {
            return n2;
        }
        if (this.afx == FontFamily.SYMBOL || this.afx == FontFamily.ZAPFDINGBATS) {
            return n2;
        }
        return n2 & 0xFFFFFFFC;
    }

    public boolean AA() {
        if (this.afz == -1) {
            return false;
        }
        return (this.afz & 1) == 1;
    }

    public boolean AB() {
        if (this.afz == -1) {
            return false;
        }
        return (this.afz & 2) == 2;
    }

    public boolean AC() {
        if (this.afz == -1) {
            return false;
        }
        return (this.afz & 4) == 4;
    }

    public boolean AD() {
        if (this.afz == -1) {
            return false;
        }
        return (this.afz & 8) == 8;
    }

    public void dE(int n2) {
        this.afz = n2;
    }

    public void eF(String string) {
        if (this.afz == -1) {
            this.afz = 0;
        }
        this.afz |= Font.eG(string);
    }

    public static int eG(String string) {
        int n2 = 0;
        if (string.indexOf(FontStyle.NORMAL.getValue()) != -1) {
            n2 |= 0;
        }
        if (string.indexOf(FontStyle.BOLD.getValue()) != -1) {
            n2 |= 1;
        }
        if (string.indexOf(FontStyle.ITALIC.getValue()) != -1) {
            n2 |= 2;
        }
        if (string.indexOf(FontStyle.OBLIQUE.getValue()) != -1) {
            n2 |= 2;
        }
        if (string.indexOf(FontStyle.UNDERLINE.getValue()) != -1) {
            n2 |= 4;
        }
        if (string.indexOf(FontStyle.LINETHROUGH.getValue()) != -1) {
            n2 |= 8;
        }
        return n2;
    }

    public e ws() {
        return this.WU;
    }

    public void a(e e2) {
        this.WU = e2;
    }

    public void z(int n2, int n3, int n4) {
        this.WU = new e(n2, n3, n4);
    }

    public p AE() {
        return this.Zy;
    }

    public p ae(boolean bl2) {
        if (this.Zy != null) {
            return this.Zy;
        }
        int n2 = this.afz;
        if (n2 == -1) {
            n2 = 0;
        }
        String string = "Helvetica";
        String string2 = "Cp1252";
        p p2 = null;
        block1 : switch (this.afx) {
            case COURIER: {
                switch (n2 & 3) {
                    case 1: {
                        string = "Courier-Bold";
                        break block1;
                    }
                    case 2: {
                        string = "Courier-Oblique";
                        break block1;
                    }
                    case 3: {
                        string = "Courier-BoldOblique";
                        break block1;
                    }
                }
                string = "Courier";
                break;
            }
            case TIMES_ROMAN: {
                switch (n2 & 3) {
                    case 1: {
                        string = "Times-Bold";
                        break block1;
                    }
                    case 2: {
                        string = "Times-Italic";
                        break block1;
                    }
                    case 3: {
                        string = "Times-BoldItalic";
                        break block1;
                    }
                }
                string = "Times-Roman";
                break;
            }
            case SYMBOL: {
                string = "Symbol";
                if (!bl2) break;
                string2 = "Symbol";
                break;
            }
            case ZAPFDINGBATS: {
                string = "ZapfDingbats";
                if (!bl2) break;
                string2 = "ZapfDingbats";
                break;
            }
            default: {
                switch (n2 & 3) {
                    case 1: {
                        string = "Helvetica-Bold";
                        break block1;
                    }
                    case 2: {
                        string = "Helvetica-Oblique";
                        break block1;
                    }
                    case 3: {
                        string = "Helvetica-BoldOblique";
                        break block1;
                    }
                }
                string = "Helvetica";
            }
        }
        try {
            p2 = p.c(string, string2, false);
        }
        catch (Exception exception) {
            throw new l(exception);
        }
        return p2;
    }

    public boolean AF() {
        return this.afx == FontFamily.UNDEFINED && this.afy == -1.0f && this.afz == -1 && this.WU == null && this.Zy == null;
    }

    public Font d(Font font) {
        e e2;
        if (font == null) {
            return this;
        }
        float f2 = font.afy;
        if (f2 == -1.0f) {
            f2 = this.afy;
        }
        int n2 = -1;
        int n3 = this.afz;
        int n4 = font.Ay();
        if (n3 != -1 || n4 != -1) {
            if (n3 == -1) {
                n3 = 0;
            }
            if (n4 == -1) {
                n4 = 0;
            }
            n2 = n3 | n4;
        }
        if ((e2 = font.WU) == null) {
            e2 = this.WU;
        }
        if (font.Zy != null) {
            return new Font(font.Zy, f2, n2, e2);
        }
        if (font.Au() != FontFamily.UNDEFINED) {
            return new Font(font.afx, f2, n2, e2);
        }
        if (this.Zy != null) {
            if (n2 == n3) {
                return new Font(this.Zy, f2, n2, e2);
            }
            return m.a(this.Av(), f2, n2, e2);
        }
        return new Font(this.afx, f2, n2, e2);
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.c((Font)object);
    }

    public static enum FontStyle {
        NORMAL("normal"),
        BOLD("bold"),
        ITALIC("italic"),
        OBLIQUE("oblique"),
        UNDERLINE("underline"),
        LINETHROUGH("line-through");

        private String code;

        private FontStyle(String code) {
            this.code = code;
        }

        public String getValue() {
            return this.code;
        }
    }

    public static enum FontFamily {
        COURIER,
        HELVETICA,
        TIMES_ROMAN,
        SYMBOL,
        ZAPFDINGBATS,
        UNDEFINED;

    }
}

