/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tgtext.text;

import com.timevale.esign.paas.tgtext.text.pdf.draw.DrawInterface;

public class TabStop {
    protected float akp;
    protected Alignment akq = Alignment.LEFT;
    protected DrawInterface akr;
    protected char aks = (char)46;

    public static TabStop l(float f2, float f3) {
        f2 = (float)Math.round(f2 * 1000.0f) / 1000.0f;
        f3 = (float)Math.round(f3 * 1000.0f) / 1000.0f;
        TabStop tabStop = new TabStop(f2 + f3 - f2 % f3);
        return tabStop;
    }

    public TabStop(float position) {
        this(position, Alignment.LEFT);
    }

    public TabStop(float position, DrawInterface leader) {
        this(position, leader, Alignment.LEFT);
    }

    public TabStop(float position, Alignment alignment) {
        this(position, null, alignment);
    }

    public TabStop(float position, Alignment alignment, char anchorChar) {
        this(position, null, alignment, anchorChar);
    }

    public TabStop(float position, DrawInterface leader, Alignment alignment) {
        this(position, leader, alignment, '.');
    }

    public TabStop(float position, DrawInterface leader, Alignment alignment, char anchorChar) {
        this.akp = position;
        this.akr = leader;
        this.akq = alignment;
        this.aks = anchorChar;
    }

    public TabStop(TabStop tabStop) {
        this(tabStop.Do(), tabStop.Dq(), tabStop.Dp(), tabStop.Dr());
    }

    public float Do() {
        return this.akp;
    }

    public void ak(float f2) {
        this.akp = f2;
    }

    public Alignment Dp() {
        return this.akq;
    }

    public void a(Alignment alignment) {
        this.akq = alignment;
    }

    public DrawInterface Dq() {
        return this.akr;
    }

    public void a(DrawInterface drawInterface) {
        this.akr = drawInterface;
    }

    public char Dr() {
        return this.aks;
    }

    public void k(char c2) {
        this.aks = c2;
    }

    public float a(float f2, float f3, float f4) {
        float f5 = this.akp;
        float f6 = f3 - f2;
        switch (this.akq) {
            case RIGHT: {
                if (f2 + f6 < this.akp) {
                    f5 = this.akp - f6;
                    break;
                }
                f5 = f2;
                break;
            }
            case CENTER: {
                if (f2 + f6 / 2.0f < this.akp) {
                    f5 = this.akp - f6 / 2.0f;
                    break;
                }
                f5 = f2;
                break;
            }
            case ANCHOR: {
                if (!Float.isNaN(f4)) {
                    if (f4 < this.akp) {
                        f5 = this.akp - (f4 - f2);
                        break;
                    }
                    f5 = f2;
                    break;
                }
                f5 = f2 + f6 < this.akp ? this.akp - f6 : f2;
            }
        }
        return f5;
    }

    public static enum Alignment {
        LEFT,
        RIGHT,
        CENTER,
        ANCHOR;

    }
}

