/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.timestamp.service.a;

import com.timevale.esign.paas.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.ASN1Set;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.DERSet;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.cmp.PKIStatus;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.cmp.PKIStatusInfo;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.cms.Attribute;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.cms.ContentInfo;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.tsp.TimeStampResp;
import com.timevale.esign.paas.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.CMSException;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.CMSSignedData;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.SignerInformation;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.SignerInformationStore;
import com.timevale.esign.paas.tgtext.bouncycastle.jce.provider.BouncyCastleProvider;
import com.timevale.esign.paas.tgtext.bouncycastle.tsp.TSPException;
import com.timevale.esign.paas.tgtext.bouncycastle.tsp.TimeStampResponse;
import com.timevale.esign.paas.tgtext.bouncycastle.tsp.TimeStampToken;
import com.timevale.esign.paas.timestamp.a.a.c;
import com.timevale.esign.paas.timestamp.enums.DigestAlgorithm;
import com.timevale.esign.paas.timestamp.exception.ErrorCode;
import com.timevale.esign.paas.timestamp.service.TimestampService;
import com.timevale.esign.paas.timestamp.utils.b;
import com.timevale.esign.paas.timestamp.utils.d;
import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import java.security.Security;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class a
implements TimestampService {
    private static final Logger log = LoggerFactory.getLogger(a.class);
    private static final String bLj = "http://tsa.tsign.cn/tsa";
    private static final String bLk = "1.2.840.113549.1.9.16.2.14";

    @Override
    public String get(byte[] text, String tsaUrl, List<String> tsaUrlBakList, DigestAlgorithm digestAlgorithm) throws com.timevale.esign.paas.timestamp.exception.a {
        String string = null;
        try {
            if (Security.getProvider("BC") == null) {
                Security.addProvider(new BouncyCastleProvider());
            }
            MessageDigest messageDigest = MessageDigest.getInstance(digestAlgorithm.getDigest());
            messageDigest.update(text);
            byte[] byArray = messageDigest.digest();
            string = this.a(StringUtils.isEmpty((String)tsaUrl) ? bLj : tsaUrl, byArray, digestAlgorithm);
            if (StringUtils.isEmpty((String)string)) {
                String string2;
                Iterator<String> iterator = tsaUrlBakList.iterator();
                while (iterator.hasNext() && !StringUtils.isNotEmpty((String)(string = this.a(string2 = iterator.next(), byArray, digestAlgorithm)))) {
                }
            }
        }
        catch (Exception exception) {
            log.warn("get timestamp response  error :{}", (Throwable)exception);
            throw new com.timevale.esign.paas.timestamp.exception.a(exception.getMessage());
        }
        return string;
    }

    @Override
    public ASN1EncodableVector getTimestamp(String timestamp) throws com.timevale.esign.paas.timestamp.exception.a {
        try {
            TimeStampResponse timeStampResponse = new TimeStampResponse(com.timevale.esign.paas.timestamp.utils.a.decode(timestamp));
            String string = bLk;
            ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(timeStampResponse.getTimeStampToken().getEncoded()));
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
            aSN1EncodableVector2.add(new ASN1ObjectIdentifier(string));
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
            aSN1EncodableVector2.add(new DERSet(aSN1Sequence));
            aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector2));
            return aSN1EncodableVector;
        }
        catch (Exception exception) {
            log.warn("get timestamp response  error :{}", (Throwable)exception);
            throw new com.timevale.esign.paas.timestamp.exception.a(exception.getMessage());
        }
    }

    @Override
    public String getTimestampToken(String timestamp) throws com.timevale.esign.paas.timestamp.exception.a {
        try {
            TimeStampResponse timeStampResponse = new TimeStampResponse(com.timevale.esign.paas.timestamp.utils.a.decode(timestamp));
            return com.timevale.esign.paas.timestamp.utils.a.encode(timeStampResponse.getTimeStampToken().getEncoded());
        }
        catch (Exception exception) {
            log.warn("getTimestampToken  error :{}", (Throwable)exception);
            throw new com.timevale.esign.paas.timestamp.exception.a(exception.getMessage());
        }
    }

    private String a(String string, byte[] byArray, DigestAlgorithm digestAlgorithm) {
        try {
            d d2 = new d(string, null, 0, null, null);
            return com.timevale.esign.paas.timestamp.utils.a.encode(d2.getTimeStampResponse(byArray, digestAlgorithm));
        }
        catch (Exception exception) {
            log.warn("get timestamp response  error :{},tsaUrl\uff1a{}", (Object)exception, (Object)string);
            return null;
        }
    }

    @Override
    public c<com.timevale.esign.paas.timestamp.a.a.b> getTimestampDetail(String timestamp) {
        Object object;
        TimeStampToken timeStampToken = null;
        try {
            object = null;
            byte[] byArray = com.timevale.esign.paas.timestamp.utils.a.decode(timestamp);
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(aSN1InputStream.readObject());
            if (aSN1Sequence.getObjectAt(0) instanceof ASN1ObjectIdentifier) {
                ContentInfo contentInfo = new ContentInfo(aSN1Sequence);
                TimeStampResp timeStampResp = new TimeStampResp(new PKIStatusInfo(PKIStatus.granted), contentInfo);
                object = new TimeStampResponse(timeStampResp);
            } else {
                object = new TimeStampResponse(byArray);
            }
            timeStampToken = ((TimeStampResponse)object).getTimeStampToken();
        }
        catch (Exception exception) {
            log.warn("convert response  error :{}", (Throwable)exception);
            return new c<com.timevale.esign.paas.timestamp.a.a.b>(ErrorCode.conResp);
        }
        object = this.a(timeStampToken);
        this.a(new c<Object>(object), timeStampToken);
        return new c<Object>(object);
    }

    @Override
    public c<com.timevale.esign.paas.timestamp.a.a.b> getTimestampFromToken(String timestampToken) {
        try {
            TimeStampToken timeStampToken = null;
            ASN1InputStream aSN1InputStream = new ASN1InputStream(com.timevale.esign.paas.timestamp.utils.a.decode(timestampToken));
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(aSN1InputStream.readObject());
            ContentInfo contentInfo = new ContentInfo(aSN1Sequence);
            timeStampToken = new TimeStampToken(contentInfo);
            com.timevale.esign.paas.timestamp.a.a.b b2 = this.a(timeStampToken);
            this.a(new c<com.timevale.esign.paas.timestamp.a.a.b>(b2), timeStampToken);
            return new c<com.timevale.esign.paas.timestamp.a.a.b>(b2);
        }
        catch (Exception exception) {
            log.warn("getTimestampFromToken  error :{}", (Throwable)exception);
            throw new com.timevale.esign.paas.timestamp.exception.a(exception.getMessage());
        }
    }

    @Override
    public c<com.timevale.esign.paas.timestamp.a.a.b> getTimestampFromPkcs7(String pkcs7Data) {
        try {
            CMSSignedData cMSSignedData = new CMSSignedData(com.timevale.esign.paas.timestamp.utils.a.decode(pkcs7Data));
            SignerInformationStore signerInformationStore = cMSSignedData.getSignerInfos();
            SignerInformation signerInformation = signerInformationStore.getSigners().iterator().next();
            Attribute attribute = signerInformation.getUnsignedAttributes().get(new ASN1ObjectIdentifier(bLk));
            if (attribute == null) {
                return new c<com.timevale.esign.paas.timestamp.a.a.b>(ErrorCode.TimeStampNull);
            }
            ASN1Set aSN1Set = attribute.getAttrValues();
            if (aSN1Set == null || aSN1Set.size() == 0) {
                return new c<com.timevale.esign.paas.timestamp.a.a.b>(ErrorCode.TimeStampNull);
            }
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(aSN1Set.getObjectAt(0));
            ContentInfo contentInfo = new ContentInfo(aSN1Sequence);
            TimeStampToken timeStampToken = new TimeStampToken(contentInfo);
            com.timevale.esign.paas.timestamp.a.a.b b2 = this.a(timeStampToken);
            this.a(new c<com.timevale.esign.paas.timestamp.a.a.b>(b2), timeStampToken);
            return new c<com.timevale.esign.paas.timestamp.a.a.b>(b2);
        }
        catch (CMSException cMSException) {
            log.warn("convert PKCS7  error :{}", (Throwable)cMSException);
            return new c<com.timevale.esign.paas.timestamp.a.a.b>(ErrorCode.conPKCS7);
        }
        catch (TSPException tSPException) {
            log.warn("convert response  error :{}", (Throwable)tSPException);
            return new c<com.timevale.esign.paas.timestamp.a.a.b>(ErrorCode.conResp);
        }
        catch (Exception exception) {
            log.warn("getTimestampFromPkcs7  error :{}", (Throwable)exception);
            return new c<com.timevale.esign.paas.timestamp.a.a.b>(ErrorCode.analyzeResp);
        }
    }

    private com.timevale.esign.paas.timestamp.a.a.b a(TimeStampToken timeStampToken) {
        com.timevale.esign.paas.timestamp.a.a.b b2 = new com.timevale.esign.paas.timestamp.a.a.b();
        b2.F(timeStampToken.getTimeStampInfo().getGenTime().getTime());
        b2.setHashAlg(b.iJ(timeStampToken.getTimeStampInfo().getHashAlgorithm().getAlgorithm().toString()));
        b2.jR(com.timevale.esign.paas.timestamp.utils.a.encode(timeStampToken.getTimeStampInfo().getMessageImprintDigest()));
        return b2;
    }

    @Override
    public c<Boolean> verifyTimestamp(byte[] text, String timestamp) {
        boolean bl2 = false;
        try {
            bl2 = d.p(text, com.timevale.esign.paas.timestamp.utils.a.decode(timestamp));
        }
        catch (Exception exception) {
            log.warn("verifyTimestamp  error :{}", (Throwable)exception);
            new c(ErrorCode.verifyResp);
        }
        return new c<Boolean>(bl2);
    }

    private c a(c<com.timevale.esign.paas.timestamp.a.a.b> c2, TimeStampToken timeStampToken) {
        try {
            Iterator iterator = timeStampToken.getCertificates().getMatches(null).iterator();
            if (iterator.hasNext()) {
                X509CertificateHolder x509CertificateHolder = (X509CertificateHolder)iterator.next();
                c2.getData().setCertBase64(com.timevale.esign.paas.timestamp.utils.a.encode(x509CertificateHolder.getEncoded()));
                Map<String, String> map = a.getMapFromDn(x509CertificateHolder.getIssuer().toString());
                c2.getData().setIssuer(map.get("CN") == null ? "" : map.get("CN"));
                map = a.getMapFromDn(x509CertificateHolder.getSubject().toString());
                c2.getData().setName(map.get("CN") == null ? "" : map.get("CN"));
                c2.getData().jS(x509CertificateHolder.getSerialNumber().toString(16).toUpperCase());
            }
        }
        catch (Exception exception) {
            log.warn("get response detail error :{}", (Throwable)exception);
            new c(ErrorCode.analyzeResp);
        }
        return c2;
    }

    private static Map<String, String> getMapFromDn(String dn2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (null != dn2) {
            String[] stringArray = dn2.split(",");
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                int n2 = stringArray[i2].indexOf(61);
                hashMap.put(stringArray[i2].substring(0, n2), stringArray[i2].substring(n2 + 1));
            }
        }
        return hashMap;
    }
}

