/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.encoder;

import com.google.zxing.pdf417.encoder.BarcodeRow;

public final class BarcodeMatrix {
    private final BarcodeRow[] matrix;
    private int currentRow;
    private final int height;
    private final int width;

    BarcodeMatrix(int height, int width) {
        this.matrix = new BarcodeRow[height + 2];
        int matrixLength = this.matrix.length;
        for (int i = 0; i < matrixLength; ++i) {
            this.matrix[i] = new BarcodeRow((width + 4) * 17 + 1);
        }
        this.width = width * 17;
        this.height = height + 2;
        this.currentRow = 0;
    }

    void set(int x, int y, byte value) {
        this.matrix[y].set(x, value);
    }

    void setMatrix(int x, int y, boolean black) {
        this.set(x, y, (byte)(black ? 1 : 0));
    }

    void startRow() {
        ++this.currentRow;
    }

    BarcodeRow getCurrentRow() {
        return this.matrix[this.currentRow];
    }

    public byte[][] getMatrix() {
        return this.getScaledMatrix(1, 1);
    }

    public byte[][] getScaledMatrix(int scale) {
        return this.getScaledMatrix(scale, scale);
    }

    public byte[][] getScaledMatrix(int xScale, int yScale) {
        byte[][] matrixOut = new byte[this.height * yScale][this.width * xScale];
        int yMax = this.height * yScale;
        for (int i = 0; i < yMax; ++i) {
            matrixOut[yMax - i - 1] = this.matrix[i / yScale].getScaledRow(xScale);
        }
        return matrixOut;
    }
}

