/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.bean.request;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.timevale.esign.paas.tech.constant.ErrorCode;
import com.timevale.esign.paas.tech.enums.AuthTypeEnum;
import com.timevale.esign.paas.tech.enums.ContactType;
import esign.utils.exception.SuperException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OnlineCreateAuthParam {
    private String organizeId;
    private String personId;
    private int authType = AuthTypeEnum.AUTH_TO_PLATFORM.getType();
    private String contact;
    private Boolean sendNotice = true;
    private String sealScope;
    private String fileType;
    private Long validDate;
    private String notifyUrl;
    private String redirectUrl;

    public String getOrganizeId() {
        return this.organizeId;
    }

    public void setOrganizeId(String organizeId) {
        this.organizeId = organizeId;
    }

    public String getPersonId() {
        return this.personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public int getAuthType() {
        return this.authType;
    }

    public void setAuthType(int authType) {
        this.authType = authType;
    }

    public String getContact() {
        return this.contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public boolean isSendNotice() {
        return this.sendNotice;
    }

    public void setSendNotice(boolean sendNotice) {
        this.sendNotice = sendNotice;
    }

    public String getSealScope() {
        return this.sealScope;
    }

    public void setSealScope(String sealScope) {
        this.sealScope = sealScope;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public Long getValidDate() {
        return this.validDate;
    }

    public void setValidDate(Long validDate) {
        this.validDate = validDate;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        OnlineCreateAuthParam onlineCreateAuthParam = (OnlineCreateAuthParam)o2;
        return this.authType == onlineCreateAuthParam.authType && this.sendNotice == onlineCreateAuthParam.sendNotice && Objects.equals(this.organizeId, onlineCreateAuthParam.organizeId) && Objects.equals(this.personId, onlineCreateAuthParam.personId) && Objects.equals(this.contact, onlineCreateAuthParam.contact) && Objects.equals(this.sealScope, onlineCreateAuthParam.sealScope) && Objects.equals(this.fileType, onlineCreateAuthParam.fileType) && Objects.equals(this.validDate, onlineCreateAuthParam.validDate) && Objects.equals(this.notifyUrl, onlineCreateAuthParam.notifyUrl) && Objects.equals(this.redirectUrl, onlineCreateAuthParam.redirectUrl);
    }

    public int hashCode() {
        return Objects.hash(this.organizeId, this.personId, this.authType, this.contact, this.sendNotice, this.sealScope, this.fileType, this.validDate, this.notifyUrl, this.redirectUrl);
    }

    public String toString() {
        return "CreateAuthParam{organizeId='" + this.organizeId + '\'' + ", personId='" + this.personId + '\'' + ", authType=" + this.authType + ", contact='" + this.contact + '\'' + ", sendNotice=" + this.sendNotice + ", sealScope='" + this.sealScope + '\'' + ", fileType='" + this.fileType + '\'' + ", validDate=" + this.validDate + ", notifyUrl='" + this.notifyUrl + '\'' + ", redirectUrl='" + this.redirectUrl + '\'' + '}';
    }

    public void check() throws SuperException {
        if (StringUtils.isBlank((String)this.organizeId)) {
            throw ErrorCode.PARAM_ERROR.e("organizeId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.checkPerSonId();
        this.checkAuthType();
        this.checkContact();
        this.checkValidDate();
    }

    private void checkPerSonId() throws SuperException {
        if (AuthTypeEnum.AUTH_TO_PERSON.getType() == this.authType && StringUtils.isBlank((String)this.personId)) {
            throw ErrorCode.PARAM_ERROR.e("\u6388\u6743\u81f3\u7ecf\u529e\u4eba\u65f6\uff0c\u4e2a\u4eba\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void checkAuthType() throws SuperException {
        if (this.authType != AuthTypeEnum.AUTH_TO_PLATFORM.getType() && this.authType != AuthTypeEnum.AUTH_TO_PERSON.getType()) {
            throw ErrorCode.PARAM_ERROR.e("\u6388\u6743\u7c7b\u578bauthType\u4f20\u5165\u7684\u503c\u9519\u8bef");
        }
    }

    private void checkContact() throws SuperException {
        if (StringUtils.isBlank((String)this.contact)) {
            throw ErrorCode.PARAM_ERROR.e("contact\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!OnlineCreateAuthParam.isPhoneNumber(this.contact) && !OnlineCreateAuthParam.isEmailAddress(this.contact)) {
            throw ErrorCode.PARAM_ERROR.e("contact\u8054\u7cfb\u65b9\u5f0f\u683c\u5f0f\u9519\u8bef");
        }
    }

    private void checkValidDate() throws SuperException {
        if (this.validDate == null || this.validDate <= System.currentTimeMillis()) {
            throw ErrorCode.PARAM_ERROR.e("validDate\u4e0d\u80fd\u4e3a\u7a7a\u6216\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4");
        }
    }

    public static boolean isPhoneNumber(String input) {
        String string = "1[3-9]\\d{9}";
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = pattern.matcher(input);
        return matcher.matches();
    }

    public static boolean isEmailAddress(String input) {
        String string = "\\w+@[\\w&&[^_]]{2,6}(\\.[a-zA-Z]{2,3}){1,2}";
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = pattern.matcher(input);
        return matcher.matches();
    }

    public int getContactType() {
        if (OnlineCreateAuthParam.isPhoneNumber(this.contact)) {
            return ContactType.PHONE_NUMBER.getType();
        }
        return ContactType.EMAIL.getType();
    }
}

