/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.bean.request;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.timevale.esign.paas.tech.bean.bean.AccountBean;
import com.timevale.esign.paas.tech.constant.ErrorException;
import com.timevale.esign.paas.tech.enums.IdNoTypeEnum;
import com.timevale.esign.paas.tech.util.ValidateUtil;
import com.timevale.esign.paas.tech.util.ValidationUtil;
import com.timevale.seal.sdk.util.StringUtils;
import esign.utils.exception.SuperException;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PersonParam
extends AccountBean {
    private String idNo;
    private IdNoTypeEnum idNoType;

    public String getIdNo() {
        return this.idNo;
    }

    public void setIdNo(String idNo) {
        this.idNo = idNo;
    }

    public IdNoTypeEnum getIdNoType() {
        return this.idNoType;
    }

    public void setIdNoType(IdNoTypeEnum idNoType) {
        this.idNoType = idNoType;
    }

    @Override
    public void check() throws SuperException {
        super.check();
        ValidationUtil.check(StringUtils.isBlank(this.idNo), ErrorException.ADD_ACCOUNT_ERROR.e("idNo\u4e3a\u7a7a"));
        ValidationUtil.check(this.idNoType == null, ErrorException.ADD_ACCOUNT_ERROR.e("idNoType\u4e3a\u7a7a"));
        ValidationUtil.check(this.getName().length() > 80 || this.getName().length() < 2, ErrorException.ADD_ACCOUNT_ERROR.e("\u4e2a\u4eba\u59d3\u540d\u53ea\u652f\u63012\u523080\u4e2a\u5b57\u7b26"));
        boolean bl2 = true;
        switch (this.idNoType) {
            case MAINLAND: {
                bl2 = ValidateUtil.IdNoValid(this.idNo);
                break;
            }
            case HONGKONG: {
                bl2 = ValidateUtil.HKNoValid(this.idNo);
                break;
            }
            case MACAO: {
                bl2 = ValidateUtil.MACNoValid(this.idNo);
                break;
            }
            case TAIWAN: {
                bl2 = ValidateUtil.TWIdNoValid(this.idNo);
                break;
            }
            case PASSPORT: {
                bl2 = ValidateUtil.ForeignPassValid(this.idNo);
                break;
            }
        }
        ValidationUtil.check(!bl2, ErrorException.ADD_ACCOUNT_ERROR.e("\u4e2a\u4eba\u8bc1\u4ef6\u53f7\u4e0e\u8bc1\u4ef6\u7c7b\u578b\u4e0d\u5339\u914d"));
    }
}

