/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.client;

import com.timevale.esign.paas.tech.bean.result.Result;
import com.timevale.esign.paas.tech.client.ServiceClient;
import com.timevale.esign.paas.tech.client.V2ServiceClient;
import com.timevale.esign.paas.tech.util.ValidationUtil;
import com.timevale.tech.sdk.bean.HttpConnectionConfig;
import com.timevale.tech.sdk.bean.ProjectConfig;
import com.timevale.tech.sdk.bean.SignatureConfig;
import esign.utils.bean.ResultUtil;
import esign.utils.exception.ErrorsDiscriptor;
import esign.utils.exception.SuperException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceClientManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceClientManager.class);
    public static final int CLIENT_VERSION_1 = 1;
    public static final int CLIENT_VERSION_2 = 2;
    public static final int CLIENT_MAX_NUM = 100;
    private static ConcurrentHashMap<String, ServiceClient> clients = new ConcurrentHashMap(128);
    private static volatile String defaultProjectId;
    private static Semaphore size;
    private static AtomicBoolean defaultInit;

    public static Result registClient(ProjectConfig projectConfig, HttpConnectionConfig httpConfig, SignatureConfig signatureConfig) {
        return ServiceClientManager.registVersionClient(projectConfig, httpConfig, signatureConfig, 2);
    }

    public static ServiceClient get(String projectId) {
        return StringUtils.isEmpty((String)projectId) ? null : clients.get(projectId);
    }

    public static ServiceClient getDefault() {
        return ServiceClientManager.get(defaultProjectId);
    }

    public static ServiceClient getClient() throws SuperException {
        ServiceClient serviceClient = ServiceClientManager.get(defaultProjectId);
        ValidationUtil.check(serviceClient == null, ErrorsDiscriptor.SERVICE_CLIENT_NON_INITIALIZE.e());
        return serviceClient;
    }

    public static void shutdown(String projectId) {
        ServiceClient serviceClient = clients.remove(projectId);
        serviceClient.shutdown();
        size.release();
    }

    static Result registDefaultClient(ProjectConfig projectConfig, HttpConnectionConfig httpConfig, SignatureConfig signatureConfig, int version) {
        Result result;
        if (!defaultInit.compareAndSet(false, true)) {
            return ResultUtil.failed(ErrorsDiscriptor.DEFAULT_CLIENT_INITIALIZING, Result.class);
        }
        if (StringUtils.isEmpty((String)defaultProjectId)) {
            result = ServiceClientManager.registVersionClient(projectConfig, httpConfig, signatureConfig, version);
        } else {
            try {
                ServiceClient serviceClient = ServiceClientManager.createVersionClient(projectConfig, httpConfig, signatureConfig, version);
                clients.put(projectConfig.getProjectId(), serviceClient);
                clients.remove(defaultProjectId);
                result = new Result();
            }
            catch (SuperException superException) {
                LOGGER.error("initializing default sdk client failed. code:{}, msg:{}", (Object)superException.getCode(), (Object)superException.getMessage());
                result = ResultUtil.failed(superException, Result.class);
            }
            catch (Exception exception) {
                LOGGER.error("initializing default sdk client error.", (Throwable)exception);
                result = ResultUtil.failed(exception, Result.class);
            }
        }
        if (result.getErrCode() == 0) {
            defaultProjectId = projectConfig.getProjectId();
        }
        defaultInit.set(false);
        return result;
    }

    private static Result registVersionClient(ProjectConfig projectConfig, HttpConnectionConfig httpConfig, SignatureConfig signatureConfig, int version) {
        if (!size.tryAcquire()) {
            return ResultUtil.failed(ErrorsDiscriptor.CANT_CREATE_MORE_CLIENT, Result.class);
        }
        try {
            ServiceClient serviceClient = ServiceClientManager.createVersionClient(projectConfig, httpConfig, signatureConfig, version);
            clients.put(projectConfig.getProjectId(), serviceClient);
        }
        catch (SuperException superException) {
            size.release();
            LOGGER.error("initializing sdk client failed. code:{}, msg:{}", (Object)superException.getCode(), (Object)superException.getMessage());
            return ResultUtil.failed(superException, Result.class);
        }
        catch (Exception exception) {
            size.release();
            LOGGER.error("initializing sdk client error.", (Throwable)exception);
            return ResultUtil.failed(exception, Result.class);
        }
        return new Result();
    }

    private static ServiceClient createVersionClient(ProjectConfig projectConfig, HttpConnectionConfig httpConfig, SignatureConfig signatureConfig, int version) throws SuperException {
        switch (version) {
            default: 
        }
        V2ServiceClient v2ServiceClient = new V2ServiceClient(projectConfig, httpConfig, signatureConfig);
        return v2ServiceClient;
    }

    static {
        size = new Semaphore(100);
        defaultInit = new AtomicBoolean(false);
    }
}

