/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.client;

import com.timevale.esign.paas.tech.client.AbstractServiceClient;
import com.timevale.tech.sdk.bean.HttpConnectionConfig;
import com.timevale.tech.sdk.bean.ProjectConfig;
import com.timevale.tech.sdk.bean.SignatureConfig;
import esign.utils.exception.SuperException;
import esign.utils.httpclient.ProjectAccesser;
import esign.utils.modeladapter.adapter.model.ModelsSecurity;
import esign.utils.modeladapter.impl.ModelsSecurityAdapter;
import esign.utils.modeladapter.impl.rpc.ProjectUrlsRpc;
import esign.utils.modeladapter.impl.rpc.bean.InterfaceUrl;
import esign.utils.modeladapter.impl.rpc.bean.InterfaceUrlsOutput;
import esign.utils.modeladapter.impl.rpc.bean.TsaServerInfo;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V2ServiceClient
extends AbstractServiceClient<InterfaceUrlsOutput> {
    private static final Logger LOGGER = LoggerFactory.getLogger(V2ServiceClient.class);

    public V2ServiceClient(ProjectConfig projectConfig, HttpConnectionConfig httpConfig, SignatureConfig signatureConfig) throws SuperException {
        super(projectConfig, httpConfig, signatureConfig);
    }

    @Override
    protected void initConfigBeforeRefresh() {
    }

    @Override
    protected InterfaceUrlsOutput requestInterfaceInfo() throws SuperException {
        ModelsSecurity modelsSecurity = SCHEME_HTTP.equalsIgnoreCase(this.networkConfig().getHttpType()) ? ModelsSecurity.HTTP : ModelsSecurity.HTTPS;
        ModelsSecurityAdapter modelsSecurityAdapter = ModelsSecurityAdapter.from(modelsSecurity);
        ProjectConfig projectConfig = this.getContext().vb();
        InterfaceUrlsOutput interfaceUrlsOutput = ProjectUrlsRpc.refresh(this.getContext().vb().getItsmApiUrl(), this.noSignCheckNetworkConfig(), new ProjectAccesser(projectConfig.getProjectId(), projectConfig.getProjectSecret()), modelsSecurityAdapter.getJsonKey());
        return interfaceUrlsOutput;
    }

    @Override
    protected void refreshTsa(InterfaceUrlsOutput output) {
        List<TsaServerInfo> list;
        if (output == null || V2ServiceClient.isEmpty(list = output.getTsas())) {
            return;
        }
        ConcurrentHashMap<String, String> concurrentHashMap = this.getContext().ve();
        for (TsaServerInfo tsaServerInfo : list) {
            if (tsaServerInfo.getIssuer() == null || tsaServerInfo.getUrl() == null) continue;
            concurrentHashMap.put(tsaServerInfo.getIssuer(), tsaServerInfo.getUrl());
        }
    }

    @Override
    protected void refreshInterface(InterfaceUrlsOutput output) {
        List<InterfaceUrl> list;
        List<InterfaceUrl> list2 = list = SCHEME_HTTP.equalsIgnoreCase(this.networkConfig().getHttpType()) ? output.getHttpUrls() : output.getHttpsUrls();
        if (V2ServiceClient.isEmpty(list)) {
            LOGGER.warn("get url info from open api failed. the return url list is empty.");
            return;
        }
        this.getContext().j(list);
    }

    public static boolean isEmpty(Collection coll) {
        return coll == null || coll.isEmpty();
    }
}

